package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ArtifactRegistryBindingBuilder extends V1alpha1ArtifactRegistryBindingFluentImpl<V1alpha1ArtifactRegistryBindingBuilder> implements VisitableBuilder<V1alpha1ArtifactRegistryBinding,V1alpha1ArtifactRegistryBindingBuilder>{

    V1alpha1ArtifactRegistryBindingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ArtifactRegistryBindingBuilder(){
            this(true);
    }
    public V1alpha1ArtifactRegistryBindingBuilder(Boolean validationEnabled){
            this(new V1alpha1ArtifactRegistryBinding(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryBindingBuilder(V1alpha1ArtifactRegistryBindingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ArtifactRegistryBindingBuilder(V1alpha1ArtifactRegistryBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ArtifactRegistryBinding(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryBindingBuilder(V1alpha1ArtifactRegistryBindingFluent<?> fluent,V1alpha1ArtifactRegistryBinding instance){
            this(fluent, instance, true);
    }
    public V1alpha1ArtifactRegistryBindingBuilder(V1alpha1ArtifactRegistryBindingFluent<?> fluent,V1alpha1ArtifactRegistryBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ArtifactRegistryBindingBuilder(V1alpha1ArtifactRegistryBinding instance){
            this(instance,true);
    }
    public V1alpha1ArtifactRegistryBindingBuilder(V1alpha1ArtifactRegistryBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ArtifactRegistryBinding build(){
            V1alpha1ArtifactRegistryBinding buildable = new V1alpha1ArtifactRegistryBinding();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistryBindingBuilder that = (V1alpha1ArtifactRegistryBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
