package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1ArtifactRegistrySpecFluentImpl<A extends V1alpha1ArtifactRegistrySpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ArtifactRegistrySpecFluent<A>{

    private Map<String,String> artifactRegistryArgs;
    private String artifactRegistryName;
    private V1alpha1HostPortBuilder http;
    private Boolean _public;
    private V1alpha1SecretKeySetRefBuilder secret;
    private String type;

    public V1alpha1ArtifactRegistrySpecFluentImpl(){
    }
    public V1alpha1ArtifactRegistrySpecFluentImpl(V1alpha1ArtifactRegistrySpec instance){
            this.withArtifactRegistryArgs(instance.getArtifactRegistryArgs());

            this.withArtifactRegistryName(instance.getArtifactRegistryName());

            this.withHttp(instance.getHttp());

            this.withPublic(instance.isPublic());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

    }

    public A addToArtifactRegistryArgs(String key,String value){
            if(this.artifactRegistryArgs == null && key != null && value != null) { this.artifactRegistryArgs = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.artifactRegistryArgs.put(key, value);} return (A)this;
    }

    public A addToArtifactRegistryArgs(Map<String,String> map){
            if(this.artifactRegistryArgs == null && map != null) { this.artifactRegistryArgs = new LinkedHashMap<String,String>(); }
            if(map != null) { this.artifactRegistryArgs.putAll(map);} return (A)this;
    }

    public A removeFromArtifactRegistryArgs(String key){
            if(this.artifactRegistryArgs == null) { return (A) this; }
            if(key != null && this.artifactRegistryArgs != null) {this.artifactRegistryArgs.remove(key);} return (A)this;
    }

    public A removeFromArtifactRegistryArgs(Map<String,String> map){
            if(this.artifactRegistryArgs == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.artifactRegistryArgs != null){this.artifactRegistryArgs.remove(key);}}} return (A)this;
    }

    public Map<String,String> getArtifactRegistryArgs(){
            return this.artifactRegistryArgs;
    }

    public A withArtifactRegistryArgs(Map<String,String> artifactRegistryArgs){
            if (artifactRegistryArgs == null) { this.artifactRegistryArgs =  null;} else {this.artifactRegistryArgs = new LinkedHashMap<String,String>(artifactRegistryArgs);} return (A) this;
    }

    public Boolean hasArtifactRegistryArgs(){
            return this.artifactRegistryArgs != null;
    }

    public String getArtifactRegistryName(){
            return this.artifactRegistryName;
    }

    public A withArtifactRegistryName(String artifactRegistryName){
            this.artifactRegistryName=artifactRegistryName; return (A) this;
    }

    public Boolean hasArtifactRegistryName(){
            return this.artifactRegistryName != null;
    }

    public A withNewArtifactRegistryName(String arg1){
            return (A)withArtifactRegistryName(new String(arg1));
    }

    public A withNewArtifactRegistryName(StringBuilder arg1){
            return (A)withArtifactRegistryName(new String(arg1));
    }

    public A withNewArtifactRegistryName(StringBuffer arg1){
            return (A)withArtifactRegistryName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1HostPort getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public V1alpha1HostPort buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(V1alpha1HostPort http){
            _visitables.get("http").remove(this.http);
            if (http!=null){ this.http= new V1alpha1HostPortBuilder(http); _visitables.get("http").add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public V1alpha1ArtifactRegistrySpecFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public V1alpha1ArtifactRegistrySpecFluent.HttpNested<A> withNewHttpLike(V1alpha1HostPort item){
            return new HttpNestedImpl(item);
    }

    public V1alpha1ArtifactRegistrySpecFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public V1alpha1ArtifactRegistrySpecFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new V1alpha1HostPortBuilder().build());
    }

    public V1alpha1ArtifactRegistrySpecFluent.HttpNested<A> editOrNewHttpLike(V1alpha1HostPort item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public Boolean isPublic(){
            return this._public;
    }

    public A withPublic(Boolean _public){
            this._public=_public; return (A) this;
    }

    public Boolean hasPublic(){
            return this._public != null;
    }

    public A withNewPublic(String arg1){
            return (A)withPublic(new Boolean(arg1));
    }

    public A withNewPublic(boolean arg1){
            return (A)withPublic(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecret instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1SecretKeySetRef getSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public V1alpha1SecretKeySetRef buildSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(V1alpha1SecretKeySetRef secret){
            _visitables.get("secret").remove(this.secret);
            if (secret!=null){ this.secret= new V1alpha1SecretKeySetRefBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
    }

    public Boolean hasSecret(){
            return this.secret != null;
    }

    public V1alpha1ArtifactRegistrySpecFluent.SecretNested<A> withNewSecret(){
            return new SecretNestedImpl();
    }

    public V1alpha1ArtifactRegistrySpecFluent.SecretNested<A> withNewSecretLike(V1alpha1SecretKeySetRef item){
            return new SecretNestedImpl(item);
    }

    public V1alpha1ArtifactRegistrySpecFluent.SecretNested<A> editSecret(){
            return withNewSecretLike(getSecret());
    }

    public V1alpha1ArtifactRegistrySpecFluent.SecretNested<A> editOrNewSecret(){
            return withNewSecretLike(getSecret() != null ? getSecret(): new V1alpha1SecretKeySetRefBuilder().build());
    }

    public V1alpha1ArtifactRegistrySpecFluent.SecretNested<A> editOrNewSecretLike(V1alpha1SecretKeySetRef item){
            return withNewSecretLike(getSecret() != null ? getSecret(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistrySpecFluentImpl that = (V1alpha1ArtifactRegistrySpecFluentImpl) o;
            if (artifactRegistryArgs != null ? !artifactRegistryArgs.equals(that.artifactRegistryArgs) :that.artifactRegistryArgs != null) return false;
            if (artifactRegistryName != null ? !artifactRegistryName.equals(that.artifactRegistryName) :that.artifactRegistryName != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            if (_public != null ? !_public.equals(that._public) :that._public != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends V1alpha1HostPortFluentImpl<V1alpha1ArtifactRegistrySpecFluent.HttpNested<N>> implements V1alpha1ArtifactRegistrySpecFluent.HttpNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1HostPortBuilder builder;
    
            HttpNestedImpl(V1alpha1HostPort item){
                    this.builder = new V1alpha1HostPortBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new V1alpha1HostPortBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ArtifactRegistrySpecFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}
    public class SecretNestedImpl<N> extends V1alpha1SecretKeySetRefFluentImpl<V1alpha1ArtifactRegistrySpecFluent.SecretNested<N>> implements V1alpha1ArtifactRegistrySpecFluent.SecretNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1SecretKeySetRefBuilder builder;
    
            SecretNestedImpl(V1alpha1SecretKeySetRef item){
                    this.builder = new V1alpha1SecretKeySetRefBuilder(this, item);
            }
            SecretNestedImpl(){
                    this.builder = new V1alpha1SecretKeySetRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ArtifactRegistrySpecFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret(){
            return and();
    }

}


}
