package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityProjectInfoBuilder extends V1alpha1CodeQualityProjectInfoFluentImpl<V1alpha1CodeQualityProjectInfoBuilder> implements VisitableBuilder<V1alpha1CodeQualityProjectInfo,V1alpha1CodeQualityProjectInfoBuilder>{

    V1alpha1CodeQualityProjectInfoFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityProjectInfoBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityProjectInfoBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityProjectInfo(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectInfoBuilder(V1alpha1CodeQualityProjectInfoFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityProjectInfoBuilder(V1alpha1CodeQualityProjectInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityProjectInfo(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectInfoBuilder(V1alpha1CodeQualityProjectInfoFluent<?> fluent,V1alpha1CodeQualityProjectInfo instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityProjectInfoBuilder(V1alpha1CodeQualityProjectInfoFluent<?> fluent,V1alpha1CodeQualityProjectInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCodeAddress(instance.getCodeAddress());

            fluent.withLastAnalysisDate(instance.getLastAnalysisDate());

            fluent.withProjectKey(instance.getProjectKey());

            fluent.withProjectName(instance.getProjectName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityProjectInfoBuilder(V1alpha1CodeQualityProjectInfo instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityProjectInfoBuilder(V1alpha1CodeQualityProjectInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCodeAddress(instance.getCodeAddress());

            this.withLastAnalysisDate(instance.getLastAnalysisDate());

            this.withProjectKey(instance.getProjectKey());

            this.withProjectName(instance.getProjectName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityProjectInfo build(){
            V1alpha1CodeQualityProjectInfo buildable = new V1alpha1CodeQualityProjectInfo();
            buildable.setCodeAddress(fluent.getCodeAddress());
            buildable.setLastAnalysisDate(fluent.getLastAnalysisDate());
            buildable.setProjectKey(fluent.getProjectKey());
            buildable.setProjectName(fluent.getProjectName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityProjectInfoBuilder that = (V1alpha1CodeQualityProjectInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
