package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityToolSpecBuilder extends V1alpha1CodeQualityToolSpecFluentImpl<V1alpha1CodeQualityToolSpecBuilder> implements VisitableBuilder<V1alpha1CodeQualityToolSpec,V1alpha1CodeQualityToolSpecBuilder>{

    V1alpha1CodeQualityToolSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityToolSpecBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityToolSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityToolSpec(), validationEnabled);
    }
    public V1alpha1CodeQualityToolSpecBuilder(V1alpha1CodeQualityToolSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityToolSpecBuilder(V1alpha1CodeQualityToolSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityToolSpec(), validationEnabled);
    }
    public V1alpha1CodeQualityToolSpecBuilder(V1alpha1CodeQualityToolSpecFluent<?> fluent,V1alpha1CodeQualityToolSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityToolSpecBuilder(V1alpha1CodeQualityToolSpecFluent<?> fluent,V1alpha1CodeQualityToolSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp(instance.getHttp());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityToolSpecBuilder(V1alpha1CodeQualityToolSpec instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityToolSpecBuilder(V1alpha1CodeQualityToolSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp(instance.getHttp());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityToolSpec build(){
            V1alpha1CodeQualityToolSpec buildable = new V1alpha1CodeQualityToolSpec();
            buildable.setHttp(fluent.getHttp());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityToolSpecBuilder that = (V1alpha1CodeQualityToolSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
