package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DocumentManagementBindingFluentImpl<A extends V1alpha1DocumentManagementBindingFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1DocumentManagementBindingFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMeta metadata;
    private V1alpha1DocumentManagementBindingSpecBuilder spec;
    private V1alpha1ServiceStatusBuilder status;

    public V1alpha1DocumentManagementBindingFluentImpl(){
    }
    public V1alpha1DocumentManagementBindingFluentImpl(V1alpha1DocumentManagementBinding instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1DocumentManagementBindingSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1alpha1DocumentManagementBindingSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1alpha1DocumentManagementBindingSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new V1alpha1DocumentManagementBindingSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1alpha1DocumentManagementBindingFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1alpha1DocumentManagementBindingFluent.SpecNested<A> withNewSpecLike(V1alpha1DocumentManagementBindingSpec item){
            return new SpecNestedImpl(item);
    }

    public V1alpha1DocumentManagementBindingFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1alpha1DocumentManagementBindingFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1alpha1DocumentManagementBindingSpecBuilder().build());
    }

    public V1alpha1DocumentManagementBindingFluent.SpecNested<A> editOrNewSpecLike(V1alpha1DocumentManagementBindingSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ServiceStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V1alpha1ServiceStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1alpha1ServiceStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new V1alpha1ServiceStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V1alpha1DocumentManagementBindingFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V1alpha1DocumentManagementBindingFluent.StatusNested<A> withNewStatusLike(V1alpha1ServiceStatus item){
            return new StatusNestedImpl(item);
    }

    public V1alpha1DocumentManagementBindingFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V1alpha1DocumentManagementBindingFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V1alpha1ServiceStatusBuilder().build());
    }

    public V1alpha1DocumentManagementBindingFluent.StatusNested<A> editOrNewStatusLike(V1alpha1ServiceStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementBindingFluentImpl that = (V1alpha1DocumentManagementBindingFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends V1alpha1DocumentManagementBindingSpecFluentImpl<V1alpha1DocumentManagementBindingFluent.SpecNested<N>> implements V1alpha1DocumentManagementBindingFluent.SpecNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1DocumentManagementBindingSpecBuilder builder;
    
            SpecNestedImpl(V1alpha1DocumentManagementBindingSpec item){
                    this.builder = new V1alpha1DocumentManagementBindingSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1alpha1DocumentManagementBindingSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1DocumentManagementBindingFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V1alpha1ServiceStatusFluentImpl<V1alpha1DocumentManagementBindingFluent.StatusNested<N>> implements V1alpha1DocumentManagementBindingFluent.StatusNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ServiceStatusBuilder builder;
    
            StatusNestedImpl(V1alpha1ServiceStatus item){
                    this.builder = new V1alpha1ServiceStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V1alpha1ServiceStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1DocumentManagementBindingFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
