package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DocumentManagementSpecBuilder extends V1alpha1DocumentManagementSpecFluentImpl<V1alpha1DocumentManagementSpecBuilder> implements VisitableBuilder<V1alpha1DocumentManagementSpec,V1alpha1DocumentManagementSpecBuilder>{

    V1alpha1DocumentManagementSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1DocumentManagementSpecBuilder(){
            this(true);
    }
    public V1alpha1DocumentManagementSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1DocumentManagementSpec(), validationEnabled);
    }
    public V1alpha1DocumentManagementSpecBuilder(V1alpha1DocumentManagementSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1DocumentManagementSpecBuilder(V1alpha1DocumentManagementSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1DocumentManagementSpec(), validationEnabled);
    }
    public V1alpha1DocumentManagementSpecBuilder(V1alpha1DocumentManagementSpecFluent<?> fluent,V1alpha1DocumentManagementSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1DocumentManagementSpecBuilder(V1alpha1DocumentManagementSpecFluent<?> fluent,V1alpha1DocumentManagementSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp(instance.getHttp());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1DocumentManagementSpecBuilder(V1alpha1DocumentManagementSpec instance){
            this(instance,true);
    }
    public V1alpha1DocumentManagementSpecBuilder(V1alpha1DocumentManagementSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp(instance.getHttp());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1DocumentManagementSpec build(){
            V1alpha1DocumentManagementSpec buildable = new V1alpha1DocumentManagementSpec();
            buildable.setHttp(fluent.getHttp());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementSpecBuilder that = (V1alpha1DocumentManagementSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
