package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1OwnerInRepositoryBuilder extends V1alpha1OwnerInRepositoryFluentImpl<V1alpha1OwnerInRepositoryBuilder> implements VisitableBuilder<V1alpha1OwnerInRepository,V1alpha1OwnerInRepositoryBuilder>{

    V1alpha1OwnerInRepositoryFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1OwnerInRepositoryBuilder(){
            this(true);
    }
    public V1alpha1OwnerInRepositoryBuilder(Boolean validationEnabled){
            this(new V1alpha1OwnerInRepository(), validationEnabled);
    }
    public V1alpha1OwnerInRepositoryBuilder(V1alpha1OwnerInRepositoryFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1OwnerInRepositoryBuilder(V1alpha1OwnerInRepositoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1OwnerInRepository(), validationEnabled);
    }
    public V1alpha1OwnerInRepositoryBuilder(V1alpha1OwnerInRepositoryFluent<?> fluent,V1alpha1OwnerInRepository instance){
            this(fluent, instance, true);
    }
    public V1alpha1OwnerInRepositoryBuilder(V1alpha1OwnerInRepositoryFluent<?> fluent,V1alpha1OwnerInRepository instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withId(instance.getId());

            fluent.withName(instance.getName());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1OwnerInRepositoryBuilder(V1alpha1OwnerInRepository instance){
            this(instance,true);
    }
    public V1alpha1OwnerInRepositoryBuilder(V1alpha1OwnerInRepository instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withId(instance.getId());

            this.withName(instance.getName());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1OwnerInRepository build(){
            V1alpha1OwnerInRepository buildable = new V1alpha1OwnerInRepository();
            buildable.setId(fluent.getId());
            buildable.setName(fluent.getName());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1OwnerInRepositoryBuilder that = (V1alpha1OwnerInRepositoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
