package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineBlueOceanInputBuilder extends V1alpha1PipelineBlueOceanInputFluentImpl<V1alpha1PipelineBlueOceanInputBuilder> implements VisitableBuilder<V1alpha1PipelineBlueOceanInput,V1alpha1PipelineBlueOceanInputBuilder>{

    V1alpha1PipelineBlueOceanInputFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineBlueOceanInputBuilder(){
            this(true);
    }
    public V1alpha1PipelineBlueOceanInputBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineBlueOceanInput(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanInputBuilder(V1alpha1PipelineBlueOceanInputFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineBlueOceanInputBuilder(V1alpha1PipelineBlueOceanInputFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineBlueOceanInput(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanInputBuilder(V1alpha1PipelineBlueOceanInputFluent<?> fluent,V1alpha1PipelineBlueOceanInput instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineBlueOceanInputBuilder(V1alpha1PipelineBlueOceanInputFluent<?> fluent,V1alpha1PipelineBlueOceanInput instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPipelineBlueOceanRef(instance.getPipelineBlueOceanRef());

            fluent.withMessage(instance.getMessage());

            fluent.withOk(instance.getOk());

            fluent.withParameters(instance.getParameters());

            fluent.withSubmitter(instance.getSubmitter());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineBlueOceanInputBuilder(V1alpha1PipelineBlueOceanInput instance){
            this(instance,true);
    }
    public V1alpha1PipelineBlueOceanInputBuilder(V1alpha1PipelineBlueOceanInput instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPipelineBlueOceanRef(instance.getPipelineBlueOceanRef());

            this.withMessage(instance.getMessage());

            this.withOk(instance.getOk());

            this.withParameters(instance.getParameters());

            this.withSubmitter(instance.getSubmitter());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineBlueOceanInput build(){
            V1alpha1PipelineBlueOceanInput buildable = new V1alpha1PipelineBlueOceanInput();
            buildable.setPipelineBlueOceanRef(fluent.getPipelineBlueOceanRef());
            buildable.setMessage(fluent.getMessage());
            buildable.setOk(fluent.getOk());
            buildable.setParameters(fluent.getParameters());
            buildable.setSubmitter(fluent.getSubmitter());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineBlueOceanInputBuilder that = (V1alpha1PipelineBlueOceanInputBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
