package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineOptionsBuilder extends V1alpha1PipelineOptionsFluentImpl<V1alpha1PipelineOptionsBuilder> implements VisitableBuilder<V1alpha1PipelineOptions,V1alpha1PipelineOptionsBuilder>{

    V1alpha1PipelineOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineOptionsBuilder(){
            this(true);
    }
    public V1alpha1PipelineOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineOptions(), validationEnabled);
    }
    public V1alpha1PipelineOptionsBuilder(V1alpha1PipelineOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineOptionsBuilder(V1alpha1PipelineOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineOptions(), validationEnabled);
    }
    public V1alpha1PipelineOptionsBuilder(V1alpha1PipelineOptionsFluent<?> fluent,V1alpha1PipelineOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineOptionsBuilder(V1alpha1PipelineOptionsFluent<?> fluent,V1alpha1PipelineOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTimeout(instance.getTimeout());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineOptionsBuilder(V1alpha1PipelineOptions instance){
            this(instance,true);
    }
    public V1alpha1PipelineOptionsBuilder(V1alpha1PipelineOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTimeout(instance.getTimeout());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineOptions build(){
            V1alpha1PipelineOptions buildable = new V1alpha1PipelineOptions();
            buildable.setTimeout(fluent.getTimeout());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineOptionsBuilder that = (V1alpha1PipelineOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
