package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineParameterBuilder extends V1alpha1PipelineParameterFluentImpl<V1alpha1PipelineParameterBuilder> implements VisitableBuilder<V1alpha1PipelineParameter,V1alpha1PipelineParameterBuilder>{

    V1alpha1PipelineParameterFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineParameterBuilder(){
            this(true);
    }
    public V1alpha1PipelineParameterBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineParameter(), validationEnabled);
    }
    public V1alpha1PipelineParameterBuilder(V1alpha1PipelineParameterFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineParameterBuilder(V1alpha1PipelineParameterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineParameter(), validationEnabled);
    }
    public V1alpha1PipelineParameterBuilder(V1alpha1PipelineParameterFluent<?> fluent,V1alpha1PipelineParameter instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineParameterBuilder(V1alpha1PipelineParameterFluent<?> fluent,V1alpha1PipelineParameter instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDescription(instance.getDescription());

            fluent.withName(instance.getName());

            fluent.withType(instance.getType());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineParameterBuilder(V1alpha1PipelineParameter instance){
            this(instance,true);
    }
    public V1alpha1PipelineParameterBuilder(V1alpha1PipelineParameter instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDescription(instance.getDescription());

            this.withName(instance.getName());

            this.withType(instance.getType());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineParameter build(){
            V1alpha1PipelineParameter buildable = new V1alpha1PipelineParameter();
            buildable.setDescription(fluent.getDescription());
            buildable.setName(fluent.getName());
            buildable.setType(fluent.getType());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineParameterBuilder that = (V1alpha1PipelineParameterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
