package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskArgumentValidationBuilder extends V1alpha1PipelineTaskArgumentValidationFluentImpl<V1alpha1PipelineTaskArgumentValidationBuilder> implements VisitableBuilder<V1alpha1PipelineTaskArgumentValidation,V1alpha1PipelineTaskArgumentValidationBuilder>{

    V1alpha1PipelineTaskArgumentValidationFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskArgumentValidationBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskArgumentValidation(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(V1alpha1PipelineTaskArgumentValidationFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(V1alpha1PipelineTaskArgumentValidationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskArgumentValidation(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(V1alpha1PipelineTaskArgumentValidationFluent<?> fluent,V1alpha1PipelineTaskArgumentValidation instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(V1alpha1PipelineTaskArgumentValidationFluent<?> fluent,V1alpha1PipelineTaskArgumentValidation instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxLength(instance.getMaxLength());

            fluent.withPattern(instance.getPattern());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(V1alpha1PipelineTaskArgumentValidation instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskArgumentValidationBuilder(V1alpha1PipelineTaskArgumentValidation instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxLength(instance.getMaxLength());

            this.withPattern(instance.getPattern());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskArgumentValidation build(){
            V1alpha1PipelineTaskArgumentValidation buildable = new V1alpha1PipelineTaskArgumentValidation();
            buildable.setMaxLength(fluent.getMaxLength());
            buildable.setPattern(fluent.getPattern());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskArgumentValidationBuilder that = (V1alpha1PipelineTaskArgumentValidationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
