package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1ProjectUserRoleOperationFluentImpl<A extends V1alpha1ProjectUserRoleOperationFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ProjectUserRoleOperationFluent<A>{

    private V1alpha1ProjectDataBuilder project;
    private List<V1alpha1UserRoleOperationBuilder> userRoleOperations;

    public V1alpha1ProjectUserRoleOperationFluentImpl(){
    }
    public V1alpha1ProjectUserRoleOperationFluentImpl(V1alpha1ProjectUserRoleOperation instance){
            this.withProject(instance.getProject());

            this.withUserRoleOperations(instance.getUserRoleOperations());

    }

    
/**
 * This method has been deprecated, please use method buildProject instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ProjectData getProject(){
            return this.project!=null?this.project.build():null;
    }

    public V1alpha1ProjectData buildProject(){
            return this.project!=null?this.project.build():null;
    }

    public A withProject(V1alpha1ProjectData project){
            _visitables.get("project").remove(this.project);
            if (project!=null){ this.project= new V1alpha1ProjectDataBuilder(project); _visitables.get("project").add(this.project);} return (A) this;
    }

    public Boolean hasProject(){
            return this.project != null;
    }

    public V1alpha1ProjectUserRoleOperationFluent.ProjectNested<A> withNewProject(){
            return new ProjectNestedImpl();
    }

    public V1alpha1ProjectUserRoleOperationFluent.ProjectNested<A> withNewProjectLike(V1alpha1ProjectData item){
            return new ProjectNestedImpl(item);
    }

    public V1alpha1ProjectUserRoleOperationFluent.ProjectNested<A> editProject(){
            return withNewProjectLike(getProject());
    }

    public V1alpha1ProjectUserRoleOperationFluent.ProjectNested<A> editOrNewProject(){
            return withNewProjectLike(getProject() != null ? getProject(): new V1alpha1ProjectDataBuilder().build());
    }

    public V1alpha1ProjectUserRoleOperationFluent.ProjectNested<A> editOrNewProjectLike(V1alpha1ProjectData item){
            return withNewProjectLike(getProject() != null ? getProject(): item);
    }

    public A addToUserRoleOperations(int index,V1alpha1UserRoleOperation item){
            if (this.userRoleOperations == null) {this.userRoleOperations = new ArrayList<V1alpha1UserRoleOperationBuilder>();}
            V1alpha1UserRoleOperationBuilder builder = new V1alpha1UserRoleOperationBuilder(item);_visitables.get("userRoleOperations").add(index >= 0 ? index : _visitables.get("userRoleOperations").size(), builder);this.userRoleOperations.add(index >= 0 ? index : userRoleOperations.size(), builder); return (A)this;
    }

    public A setToUserRoleOperations(int index,V1alpha1UserRoleOperation item){
            if (this.userRoleOperations == null) {this.userRoleOperations = new ArrayList<V1alpha1UserRoleOperationBuilder>();}
            V1alpha1UserRoleOperationBuilder builder = new V1alpha1UserRoleOperationBuilder(item);
            if (index < 0 || index >= _visitables.get("userRoleOperations").size()) { _visitables.get("userRoleOperations").add(builder); } else { _visitables.get("userRoleOperations").set(index, builder);}
            if (index < 0 || index >= userRoleOperations.size()) { userRoleOperations.add(builder); } else { userRoleOperations.set(index, builder);}
             return (A)this;
    }

    public A addToUserRoleOperations(V1alpha1UserRoleOperation... items){
            if (this.userRoleOperations == null) {this.userRoleOperations = new ArrayList<V1alpha1UserRoleOperationBuilder>();}
            for (V1alpha1UserRoleOperation item : items) {V1alpha1UserRoleOperationBuilder builder = new V1alpha1UserRoleOperationBuilder(item);_visitables.get("userRoleOperations").add(builder);this.userRoleOperations.add(builder);} return (A)this;
    }

    public A addAllToUserRoleOperations(Collection<V1alpha1UserRoleOperation> items){
            if (this.userRoleOperations == null) {this.userRoleOperations = new ArrayList<V1alpha1UserRoleOperationBuilder>();}
            for (V1alpha1UserRoleOperation item : items) {V1alpha1UserRoleOperationBuilder builder = new V1alpha1UserRoleOperationBuilder(item);_visitables.get("userRoleOperations").add(builder);this.userRoleOperations.add(builder);} return (A)this;
    }

    public A removeFromUserRoleOperations(V1alpha1UserRoleOperation... items){
            for (V1alpha1UserRoleOperation item : items) {V1alpha1UserRoleOperationBuilder builder = new V1alpha1UserRoleOperationBuilder(item);_visitables.get("userRoleOperations").remove(builder);if (this.userRoleOperations != null) {this.userRoleOperations.remove(builder);}} return (A)this;
    }

    public A removeAllFromUserRoleOperations(Collection<V1alpha1UserRoleOperation> items){
            for (V1alpha1UserRoleOperation item : items) {V1alpha1UserRoleOperationBuilder builder = new V1alpha1UserRoleOperationBuilder(item);_visitables.get("userRoleOperations").remove(builder);if (this.userRoleOperations != null) {this.userRoleOperations.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildUserRoleOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1UserRoleOperation> getUserRoleOperations(){
            return build(userRoleOperations);
    }

    public List<V1alpha1UserRoleOperation> buildUserRoleOperations(){
            return build(userRoleOperations);
    }

    public V1alpha1UserRoleOperation buildUserRoleOperation(int index){
            return this.userRoleOperations.get(index).build();
    }

    public V1alpha1UserRoleOperation buildFirstUserRoleOperation(){
            return this.userRoleOperations.get(0).build();
    }

    public V1alpha1UserRoleOperation buildLastUserRoleOperation(){
            return this.userRoleOperations.get(userRoleOperations.size() - 1).build();
    }

    public V1alpha1UserRoleOperation buildMatchingUserRoleOperation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1UserRoleOperationBuilder> predicate){
            for (V1alpha1UserRoleOperationBuilder item: userRoleOperations) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingUserRoleOperation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1UserRoleOperationBuilder> predicate){
            for (V1alpha1UserRoleOperationBuilder item: userRoleOperations) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withUserRoleOperations(List<V1alpha1UserRoleOperation> userRoleOperations){
            if (this.userRoleOperations != null) { _visitables.get("userRoleOperations").removeAll(this.userRoleOperations);}
            if (userRoleOperations != null) {this.userRoleOperations = new ArrayList<V1alpha1UserRoleOperationBuilder>(); for (V1alpha1UserRoleOperation item : userRoleOperations){this.addToUserRoleOperations(item);}} else { this.userRoleOperations = null;} return (A) this;
    }

    public A withUserRoleOperations(V1alpha1UserRoleOperation... userRoleOperations){
            if (this.userRoleOperations != null) {this.userRoleOperations.clear();}
            if (userRoleOperations != null) {for (V1alpha1UserRoleOperation item :userRoleOperations){ this.addToUserRoleOperations(item);}} return (A) this;
    }

    public Boolean hasUserRoleOperations(){
            return userRoleOperations != null && !userRoleOperations.isEmpty();
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> addNewUserRoleOperation(){
            return new UserRoleOperationsNestedImpl();
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> addNewUserRoleOperationLike(V1alpha1UserRoleOperation item){
            return new UserRoleOperationsNestedImpl(-1, item);
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> setNewUserRoleOperationLike(int index,V1alpha1UserRoleOperation item){
            return new UserRoleOperationsNestedImpl(index, item);
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> editUserRoleOperation(int index){
            if (userRoleOperations.size() <= index) throw new RuntimeException("Can't edit userRoleOperations. Index exceeds size.");
            return setNewUserRoleOperationLike(index, buildUserRoleOperation(index));
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> editFirstUserRoleOperation(){
            if (userRoleOperations.size() == 0) throw new RuntimeException("Can't edit first userRoleOperations. The list is empty.");
            return setNewUserRoleOperationLike(0, buildUserRoleOperation(0));
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> editLastUserRoleOperation(){
            int index = userRoleOperations.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last userRoleOperations. The list is empty.");
            return setNewUserRoleOperationLike(index, buildUserRoleOperation(index));
    }

    public V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<A> editMatchingUserRoleOperation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1UserRoleOperationBuilder> predicate){
            int index = -1;
            for (int i=0;i<userRoleOperations.size();i++) { 
            if (predicate.apply(userRoleOperations.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching userRoleOperations. No match found.");
            return setNewUserRoleOperationLike(index, buildUserRoleOperation(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectUserRoleOperationFluentImpl that = (V1alpha1ProjectUserRoleOperationFluentImpl) o;
            if (project != null ? !project.equals(that.project) :that.project != null) return false;
            if (userRoleOperations != null ? !userRoleOperations.equals(that.userRoleOperations) :that.userRoleOperations != null) return false;
            return true;
    }


    public class ProjectNestedImpl<N> extends V1alpha1ProjectDataFluentImpl<V1alpha1ProjectUserRoleOperationFluent.ProjectNested<N>> implements V1alpha1ProjectUserRoleOperationFluent.ProjectNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ProjectDataBuilder builder;
    
            ProjectNestedImpl(V1alpha1ProjectData item){
                    this.builder = new V1alpha1ProjectDataBuilder(this, item);
            }
            ProjectNestedImpl(){
                    this.builder = new V1alpha1ProjectDataBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ProjectUserRoleOperationFluentImpl.this.withProject(builder.build());
    }
    public N endProject(){
            return and();
    }

}
    public class UserRoleOperationsNestedImpl<N> extends V1alpha1UserRoleOperationFluentImpl<V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<N>> implements V1alpha1ProjectUserRoleOperationFluent.UserRoleOperationsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1UserRoleOperationBuilder builder;
        private final int index;
    
            UserRoleOperationsNestedImpl(int index,V1alpha1UserRoleOperation item){
                    this.index = index;
                    this.builder = new V1alpha1UserRoleOperationBuilder(this, item);
            }
            UserRoleOperationsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1UserRoleOperationBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ProjectUserRoleOperationFluentImpl.this.setToUserRoleOperations(index, builder.build());
    }
    public N endUserRoleOperation(){
            return and();
    }

}


}
