package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolSelectorBuilder extends V1alpha1ToolSelectorFluentImpl<V1alpha1ToolSelectorBuilder> implements VisitableBuilder<V1alpha1ToolSelector,V1alpha1ToolSelectorBuilder>{

    V1alpha1ToolSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolSelectorBuilder(){
            this(true);
    }
    public V1alpha1ToolSelectorBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolSelector(), validationEnabled);
    }
    public V1alpha1ToolSelectorBuilder(V1alpha1ToolSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolSelectorBuilder(V1alpha1ToolSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolSelector(), validationEnabled);
    }
    public V1alpha1ToolSelectorBuilder(V1alpha1ToolSelectorFluent<?> fluent,V1alpha1ToolSelector instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolSelectorBuilder(V1alpha1ToolSelectorFluent<?> fluent,V1alpha1ToolSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withFieldPath(instance.getFieldPath());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withResourceVersion(instance.getResourceVersion());

            fluent.withUid(instance.getUid());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolSelectorBuilder(V1alpha1ToolSelector instance){
            this(instance,true);
    }
    public V1alpha1ToolSelectorBuilder(V1alpha1ToolSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withFieldPath(instance.getFieldPath());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withResourceVersion(instance.getResourceVersion());

            this.withUid(instance.getUid());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolSelector build(){
            V1alpha1ToolSelector buildable = new V1alpha1ToolSelector();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setFieldPath(fluent.getFieldPath());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setResourceVersion(fluent.getResourceVersion());
            buildable.setUid(fluent.getUid());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolSelectorBuilder that = (V1alpha1ToolSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
