package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1UserMetaBuilder extends V1alpha1UserMetaFluentImpl<V1alpha1UserMetaBuilder> implements VisitableBuilder<V1alpha1UserMeta,V1alpha1UserMetaBuilder>{

    V1alpha1UserMetaFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1UserMetaBuilder(){
            this(true);
    }
    public V1alpha1UserMetaBuilder(Boolean validationEnabled){
            this(new V1alpha1UserMeta(), validationEnabled);
    }
    public V1alpha1UserMetaBuilder(V1alpha1UserMetaFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1UserMetaBuilder(V1alpha1UserMetaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1UserMeta(), validationEnabled);
    }
    public V1alpha1UserMetaBuilder(V1alpha1UserMetaFluent<?> fluent,V1alpha1UserMeta instance){
            this(fluent, instance, true);
    }
    public V1alpha1UserMetaBuilder(V1alpha1UserMetaFluent<?> fluent,V1alpha1UserMeta instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEmail(instance.getEmail());

            fluent.withMetadata(instance.getMetadata());

            fluent.withUsername(instance.getUsername());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1UserMetaBuilder(V1alpha1UserMeta instance){
            this(instance,true);
    }
    public V1alpha1UserMetaBuilder(V1alpha1UserMeta instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEmail(instance.getEmail());

            this.withMetadata(instance.getMetadata());

            this.withUsername(instance.getUsername());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1UserMeta build(){
            V1alpha1UserMeta buildable = new V1alpha1UserMeta();
            buildable.setEmail(fluent.getEmail());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setUsername(fluent.getUsername());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1UserMetaBuilder that = (V1alpha1UserMetaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
