/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.controller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.alauda.devops.java.client.extend.controller.reconciler.Request;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.util.Reflect;
import io.kubernetes.client.util.exception.ObjectMetaReflectException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controllers {
    private static final Logger log = LoggerFactory.getLogger(Controllers.class);

    public static <ApiType> Function<ApiType, Request> defaultReflectiveKeyFunc() {
        return obj -> {
            try {
                V1ObjectMeta objectMeta = Reflect.objectMetadata((Object)obj);
                return new Request(objectMeta.getNamespace(), objectMeta.getName());
            }
            catch (ObjectMetaReflectException e) {
                log.error("Fail to access object-meta from {}..", obj.getClass());
                return null;
            }
        };
    }

    public static ThreadFactory namedControllerThreadFactory(String controllerName) {
        return new ThreadFactoryBuilder().setNameFormat(controllerName + "-%d").build();
    }
}

