/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.controller;

import io.alauda.devops.java.client.extend.controller.Controller;
import io.alauda.devops.java.client.extend.controller.reconciler.Reconciler;
import io.alauda.devops.java.client.extend.controller.reconciler.Request;
import io.alauda.devops.java.client.extend.controller.reconciler.Result;
import io.alauda.devops.java.client.extend.wait.Wait;
import io.alauda.devops.java.client.extend.workqueue.RateLimitingQueue;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultController
implements Controller {
    private static final Logger log = LoggerFactory.getLogger(DefaultController.class);
    private Reconciler reconciler;
    private String name;
    private int workerCount;
    private ScheduledExecutorService workerThreadPool;
    private RateLimitingQueue<Request> workQueue;
    private Supplier<Boolean>[] readyFuncs;
    private Duration readyTimeout;
    private Duration readyCheckInternal;

    public DefaultController(Reconciler reconciler, RateLimitingQueue<Request> workQueue, Supplier<Boolean> ... readyFuncs) {
        this.reconciler = reconciler;
        this.workQueue = workQueue;
        this.readyFuncs = readyFuncs;
        this.readyTimeout = Duration.ofSeconds(30L);
        this.readyCheckInternal = Duration.ofSeconds(1L);
    }

    private boolean preFlightCheck() {
        if (this.workerCount <= 0) {
            log.error("Fail to start controller {}: worker count must be positive.");
            return false;
        }
        if (this.workerThreadPool == null) {
            log.error("Fail to start controller {}: missing worker thread-pool.");
            return false;
        }
        if (!this.isReady()) {
            log.error("Timed out waiting for cache to be synced.");
            return false;
        }
        return true;
    }

    private boolean isReady() {
        boolean synced = true;
        if (this.readyFuncs.length > 0) {
            synced = Wait.poll(this.readyCheckInternal, this.readyTimeout, () -> {
                boolean ready = true;
                for (Supplier<Boolean> cacheHasSyncedFunc : this.readyFuncs) {
                    ready = ready && cacheHasSyncedFunc.get() != false;
                }
                return ready;
            });
        }
        return synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.preFlightCheck()) {
            log.error("Controller {} failed pre-run check, exiting..", (Object)this.name);
            return;
        }
        CountDownLatch latch = new CountDownLatch(this.workerCount);
        int i = 0;
        while (i < this.workerCount) {
            int workerIndex = i++;
            this.workerThreadPool.scheduleWithFixedDelay(() -> {
                log.debug("Starting controller {} worker {}..", (Object)this.name, (Object)workerIndex);
                this.worker();
                latch.countDown();
                log.debug("Exiting controller {} worker {}..", (Object)this.name, (Object)workerIndex);
            }, 0L, 1L, TimeUnit.SECONDS);
        }
        try {
            log.debug("Controller {} bootstrapping..", (Object)this.name);
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("Aborting controller.", (Throwable)e);
        }
        finally {
            log.info("Controller {} exited", (Object)this.name);
        }
    }

    @Override
    public void shutdown() {
        this.workQueue.shutDown();
        this.workerThreadPool.shutdown();
    }

    private void worker() {
        while (!this.workQueue.isShuttingDown()) {
            Request request;
            block9: {
                request = null;
                try {
                    request = (Request)this.workQueue.get();
                }
                catch (InterruptedException e) {
                    log.error("Controller worker interrupted.. keeps working until work-queue shutdown", (Throwable)e);
                    if (request == null) break block9;
                    this.workQueue.addRateLimited(request);
                }
            }
            if (request == null) {
                log.info("Controller {} worker exiting because work-queue has shutdown..", (Object)this.name);
                return;
            }
            log.debug("Controller {} start reconciling {}..", (Object)this.name, (Object)request);
            Result result = this.reconciler.reconcile(request);
            try {
                if (result.isRequeue()) {
                    if (result.getRequeueAfter() == null) {
                        log.debug("Controller {} reconciling {} failed, requeuing {}..", (Object)this.name, (Object)request);
                        this.workQueue.addRateLimited(request);
                        continue;
                    }
                    log.debug("Controller {} reconciling {} failed, requeuing after {}..", new Object[]{this.name, request, result.getRequeueAfter()});
                    this.workQueue.addAfter(request, result.getRequeueAfter());
                    continue;
                }
                this.workQueue.forget(request);
            }
            finally {
                this.workQueue.done(request);
                log.debug("Controller {} finished reconciling {}..", (Object)this.name, (Object)request);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public ExecutorService getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    public void setWorkerThreadPool(ScheduledExecutorService workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    public Reconciler getReconciler() {
        return this.reconciler;
    }

    public void setReconciler(Reconciler reconciler) {
        this.reconciler = reconciler;
    }

    public Duration getReadyTimeout() {
        return this.readyTimeout;
    }

    public void setReadyTimeout(Duration readyTimeout) {
        this.readyTimeout = readyTimeout;
    }

    public Duration getReadyCheckInternal() {
        return this.readyCheckInternal;
    }

    public void setReadyCheckInternal(Duration readyCheckInternal) {
        this.readyCheckInternal = readyCheckInternal;
    }
}

