/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.controller.builder;

import com.google.gson.reflect.TypeToken;
import io.alauda.devops.java.client.extend.controller.Controller;
import io.alauda.devops.java.client.extend.controller.ControllerWatch;
import io.alauda.devops.java.client.extend.controller.Controllers;
import io.alauda.devops.java.client.extend.controller.DefaultController;
import io.alauda.devops.java.client.extend.controller.reconciler.Reconciler;
import io.alauda.devops.java.client.extend.controller.reconciler.Request;
import io.alauda.devops.java.client.extend.workqueue.DefaultRateLimitingQueue;
import io.alauda.devops.java.client.extend.workqueue.RateLimitingQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class DefaultControllerBuilder {
    private int workerCount = 16;
    private String controllerName = "default-controller";
    private RateLimitingQueue<Request> workQueue = new DefaultRateLimitingQueue<Request>(Executors.newSingleThreadExecutor());
    private SharedInformerFactory informerFactory;
    private List<Supplier<Boolean>> readyFuncs = new ArrayList<Supplier<Boolean>>();
    private Reconciler reconciler;

    DefaultControllerBuilder() {
    }

    DefaultControllerBuilder(SharedInformerFactory informerFactory) {
        this();
        this.informerFactory = informerFactory;
    }

    public <ApiType> DefaultControllerBuilder watch(ControllerWatch<ApiType> watch) {
        Class<ApiType> apiTypeClass = watch.getResourceClass();
        SharedIndexInformer<ApiType> informer = this.getExistingSharedIndexInformer(this.informerFactory, apiTypeClass);
        if (informer == null) {
            throw new IllegalStateException(String.format("Missing informer for resource %s, check if informer already constructed in the informerFactory", apiTypeClass));
        }
        informer.addEventHandler(watch.getResourceEventHandler());
        return this;
    }

    private <ApiType> SharedIndexInformer<ApiType> getExistingSharedIndexInformer(SharedInformerFactory factory, Class<ApiType> apiTypeClass) {
        SharedIndexInformer informer = null;
        try {
            Field f = factory.getClass().getDeclaredField("informers");
            f.setAccessible(true);
            Map informers = (Map)f.get(factory);
            if (informers != null) {
                informer = (SharedIndexInformer)informers.get(TypeToken.get(apiTypeClass).getType());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return informer;
    }

    public DefaultControllerBuilder withName(String controllerName) {
        this.controllerName = controllerName;
        return this;
    }

    public DefaultControllerBuilder withWorkQueue(RateLimitingQueue<Request> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public DefaultControllerBuilder withReadyFunc(Supplier<Boolean> readyFunc) {
        this.readyFuncs.add(readyFunc);
        return this;
    }

    public DefaultControllerBuilder withWorkerCount(int workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    public DefaultControllerBuilder withReconciler(Reconciler reconciler) {
        this.reconciler = reconciler;
        return this;
    }

    public Controller build() throws IllegalStateException {
        if (this.reconciler == null) {
            throw new IllegalStateException("Missing reconciler when building controller.");
        }
        DefaultController controller = new DefaultController(this.reconciler, this.workQueue, (Supplier[])this.readyFuncs.stream().toArray(Supplier[]::new));
        controller.setName(this.controllerName);
        controller.setWorkerCount(this.workerCount);
        controller.setWorkerThreadPool(Executors.newScheduledThreadPool(this.workerCount, Controllers.namedControllerThreadFactory(this.controllerName)));
        controller.setReconciler(this.reconciler);
        return controller;
    }
}

