/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class MaxOfRateLimiter<T>
implements RateLimiter<T> {
    private List<RateLimiter<T>> rateLimiters;

    public MaxOfRateLimiter(List<RateLimiter<T>> rateLimiters) {
        this.rateLimiters = rateLimiters;
    }

    @SafeVarargs
    public MaxOfRateLimiter(RateLimiter<T> ... rateLimiters) {
        this(Arrays.asList(rateLimiters));
    }

    @Override
    public Duration when(T item) {
        Duration max = Duration.ZERO;
        for (RateLimiter<T> r : this.rateLimiters) {
            Duration current = r.when(item);
            if (current.compareTo(max) <= 0) continue;
            max = current;
        }
        return max;
    }

    @Override
    public void forget(T item) {
        this.rateLimiters.forEach(r -> r.forget(item));
    }

    @Override
    public int numRequeues(T item) {
        int max = 0;
        for (RateLimiter<T> r : this.rateLimiters) {
            int current = r.numRequeues(item);
            if (current <= max) continue;
            max = current;
        }
        return max;
    }
}

