/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.models.V1alpha1BindingCondition;
import io.alauda.devops.java.client.models.V1alpha1CodeQualityAnalyzeMetric;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="CodeQualityCondition presents CodeQualityProject analyze info")
public class V1alpha1CodeQualityCondition {
    @SerializedName(value="BindingCondition")
    private V1alpha1BindingCondition bindingCondition = null;
    @SerializedName(value="branch")
    private String branch = null;
    @SerializedName(value="isMain")
    private Boolean isMain = null;
    @SerializedName(value="metrics")
    private Map<String, V1alpha1CodeQualityAnalyzeMetric> metrics = new HashMap<String, V1alpha1CodeQualityAnalyzeMetric>();
    @SerializedName(value="qualityGate")
    private String qualityGate = null;
    @SerializedName(value="visibility")
    private String visibility = null;

    public V1alpha1CodeQualityCondition bindingCondition(V1alpha1BindingCondition bindingCondition) {
        this.bindingCondition = bindingCondition;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha1BindingCondition getBindingCondition() {
        return this.bindingCondition;
    }

    public void setBindingCondition(V1alpha1BindingCondition bindingCondition) {
        this.bindingCondition = bindingCondition;
    }

    public V1alpha1CodeQualityCondition branch(String branch) {
        this.branch = branch;
        return this;
    }

    @ApiModelProperty(required=true, value="Branch defines analyze code branch, default is master")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public V1alpha1CodeQualityCondition isMain(Boolean isMain) {
        this.isMain = isMain;
        return this;
    }

    @ApiModelProperty(required=true, value="IsMain defines whether the branch is the main branch")
    public Boolean isIsMain() {
        return this.isMain;
    }

    public void setIsMain(Boolean isMain) {
        this.isMain = isMain;
    }

    public V1alpha1CodeQualityCondition metrics(Map<String, V1alpha1CodeQualityAnalyzeMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    public V1alpha1CodeQualityCondition putMetricsItem(String key, V1alpha1CodeQualityAnalyzeMetric metricsItem) {
        this.metrics.put(key, metricsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Metrics define a series of metrics of this project")
    public Map<String, V1alpha1CodeQualityAnalyzeMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, V1alpha1CodeQualityAnalyzeMetric> metrics) {
        this.metrics = metrics;
    }

    public V1alpha1CodeQualityCondition qualityGate(String qualityGate) {
        this.qualityGate = qualityGate;
        return this;
    }

    @ApiModelProperty(required=true, value="QualityGate defines project use which quality gate")
    public String getQualityGate() {
        return this.qualityGate;
    }

    public void setQualityGate(String qualityGate) {
        this.qualityGate = qualityGate;
    }

    public V1alpha1CodeQualityCondition visibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(required=true, value="Public defines project visible")
    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1CodeQualityCondition v1alpha1CodeQualityCondition = (V1alpha1CodeQualityCondition)o;
        return Objects.equals(this.bindingCondition, v1alpha1CodeQualityCondition.bindingCondition) && Objects.equals(this.branch, v1alpha1CodeQualityCondition.branch) && Objects.equals(this.isMain, v1alpha1CodeQualityCondition.isMain) && Objects.equals(this.metrics, v1alpha1CodeQualityCondition.metrics) && Objects.equals(this.qualityGate, v1alpha1CodeQualityCondition.qualityGate) && Objects.equals(this.visibility, v1alpha1CodeQualityCondition.visibility);
    }

    public int hashCode() {
        return Objects.hash(this.bindingCondition, this.branch, this.isMain, this.metrics, this.qualityGate, this.visibility);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1CodeQualityCondition {\n");
        sb.append("    bindingCondition: ").append(this.toIndentedString(this.bindingCondition)).append("\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    isMain: ").append(this.toIndentedString(this.isMain)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    qualityGate: ").append(this.toIndentedString(this.qualityGate)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

