/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.models.V1alpha1CodeRepositoryRef;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceGit;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceSvn;
import io.alauda.devops.java.client.models.V1alpha1SecretKeySetRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="PipelineSource source code specification for Pipeline")
public class V1alpha1PipelineSource {
    @SerializedName(value="codeRepository")
    private V1alpha1CodeRepositoryRef codeRepository = null;
    @SerializedName(value="git")
    private V1alpha1PipelineSourceGit git = null;
    @SerializedName(value="secret")
    private V1alpha1SecretKeySetRef secret = null;
    @SerializedName(value="sourceType")
    private String sourceType = null;
    @SerializedName(value="svn")
    private V1alpha1PipelineSourceSvn svn = null;

    public V1alpha1PipelineSource codeRepository(V1alpha1CodeRepositoryRef codeRepository) {
        this.codeRepository = codeRepository;
        return this;
    }

    @ApiModelProperty(value="CodeRepository contains git url and user info")
    public V1alpha1CodeRepositoryRef getCodeRepository() {
        return this.codeRepository;
    }

    public void setCodeRepository(V1alpha1CodeRepositoryRef codeRepository) {
        this.codeRepository = codeRepository;
    }

    public V1alpha1PipelineSource git(V1alpha1PipelineSourceGit git) {
        this.git = git;
        return this;
    }

    @ApiModelProperty(value="Git is the git code repository settings of the pipeline source.")
    public V1alpha1PipelineSourceGit getGit() {
        return this.git;
    }

    public void setGit(V1alpha1PipelineSourceGit git) {
        this.git = git;
    }

    public V1alpha1PipelineSource secret(V1alpha1SecretKeySetRef secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(value="Secret is the secret to access the code repository.")
    public V1alpha1SecretKeySetRef getSecret() {
        return this.secret;
    }

    public void setSecret(V1alpha1SecretKeySetRef secret) {
        this.secret = secret;
    }

    public V1alpha1PipelineSource sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(required=true, value="Source Type is the type of Pipeline Source")
    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public V1alpha1PipelineSource svn(V1alpha1PipelineSourceSvn svn) {
        this.svn = svn;
        return this;
    }

    @ApiModelProperty(value="Svn is the svn code repository settings of the pipeline source.")
    public V1alpha1PipelineSourceSvn getSvn() {
        return this.svn;
    }

    public void setSvn(V1alpha1PipelineSourceSvn svn) {
        this.svn = svn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PipelineSource v1alpha1PipelineSource = (V1alpha1PipelineSource)o;
        return Objects.equals(this.codeRepository, v1alpha1PipelineSource.codeRepository) && Objects.equals(this.git, v1alpha1PipelineSource.git) && Objects.equals(this.secret, v1alpha1PipelineSource.secret) && Objects.equals(this.sourceType, v1alpha1PipelineSource.sourceType) && Objects.equals(this.svn, v1alpha1PipelineSource.svn);
    }

    public int hashCode() {
        return Objects.hash(this.codeRepository, this.git, this.secret, this.sourceType, this.svn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1PipelineSource {\n");
        sb.append("    codeRepository: ").append(this.toIndentedString(this.codeRepository)).append("\n");
        sb.append("    git: ").append(this.toIndentedString(this.git)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString(this.sourceType)).append("\n");
        sb.append("    svn: ").append(this.toIndentedString(this.svn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

