package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ArtifactRegistryManagerBuilder extends V1alpha1ArtifactRegistryManagerFluentImpl<V1alpha1ArtifactRegistryManagerBuilder> implements VisitableBuilder<V1alpha1ArtifactRegistryManager,V1alpha1ArtifactRegistryManagerBuilder>{

    V1alpha1ArtifactRegistryManagerFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ArtifactRegistryManagerBuilder(){
            this(true);
    }
    public V1alpha1ArtifactRegistryManagerBuilder(Boolean validationEnabled){
            this(new V1alpha1ArtifactRegistryManager(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryManagerBuilder(V1alpha1ArtifactRegistryManagerFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ArtifactRegistryManagerBuilder(V1alpha1ArtifactRegistryManagerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ArtifactRegistryManager(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryManagerBuilder(V1alpha1ArtifactRegistryManagerFluent<?> fluent,V1alpha1ArtifactRegistryManager instance){
            this(fluent, instance, true);
    }
    public V1alpha1ArtifactRegistryManagerBuilder(V1alpha1ArtifactRegistryManagerFluent<?> fluent,V1alpha1ArtifactRegistryManager instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ArtifactRegistryManagerBuilder(V1alpha1ArtifactRegistryManager instance){
            this(instance,true);
    }
    public V1alpha1ArtifactRegistryManagerBuilder(V1alpha1ArtifactRegistryManager instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ArtifactRegistryManager build(){
            V1alpha1ArtifactRegistryManager buildable = new V1alpha1ArtifactRegistryManager();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistryManagerBuilder that = (V1alpha1ArtifactRegistryManagerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
