package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingAccountBuilder extends V1alpha1CodeRepoBindingAccountFluentImpl<V1alpha1CodeRepoBindingAccountBuilder> implements VisitableBuilder<V1alpha1CodeRepoBindingAccount,V1alpha1CodeRepoBindingAccountBuilder>{

    V1alpha1CodeRepoBindingAccountFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoBindingAccountBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoBindingAccountBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoBindingAccount(), validationEnabled);
    }
    public V1alpha1CodeRepoBindingAccountBuilder(V1alpha1CodeRepoBindingAccountFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoBindingAccountBuilder(V1alpha1CodeRepoBindingAccountFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoBindingAccount(), validationEnabled);
    }
    public V1alpha1CodeRepoBindingAccountBuilder(V1alpha1CodeRepoBindingAccountFluent<?> fluent,V1alpha1CodeRepoBindingAccount instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoBindingAccountBuilder(V1alpha1CodeRepoBindingAccountFluent<?> fluent,V1alpha1CodeRepoBindingAccount instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withOwners(instance.getOwners());

            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoBindingAccountBuilder(V1alpha1CodeRepoBindingAccount instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoBindingAccountBuilder(V1alpha1CodeRepoBindingAccount instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withOwners(instance.getOwners());

            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoBindingAccount build(){
            V1alpha1CodeRepoBindingAccount buildable = new V1alpha1CodeRepoBindingAccount();
            buildable.setOwners(fluent.getOwners());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingAccountBuilder that = (V1alpha1CodeRepoBindingAccountBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
