package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingRepositoriesFluentImpl<A extends V1alpha1CodeRepoBindingRepositoriesFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepoBindingRepositoriesFluent<A>{

    private String apiVersion;
    private String kind;
    private List<V1alpha1CodeRepositoryOwnerBuilder> owners;
    private String type;

    public V1alpha1CodeRepoBindingRepositoriesFluentImpl(){
    }
    public V1alpha1CodeRepoBindingRepositoriesFluentImpl(V1alpha1CodeRepoBindingRepositories instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withOwners(instance.getOwners());

            this.withType(instance.getType());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToOwners(int index,V1alpha1CodeRepositoryOwner item){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerBuilder>();}
            V1alpha1CodeRepositoryOwnerBuilder builder = new V1alpha1CodeRepositoryOwnerBuilder(item);_visitables.get("owners").add(index >= 0 ? index : _visitables.get("owners").size(), builder);this.owners.add(index >= 0 ? index : owners.size(), builder); return (A)this;
    }

    public A setToOwners(int index,V1alpha1CodeRepositoryOwner item){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerBuilder>();}
            V1alpha1CodeRepositoryOwnerBuilder builder = new V1alpha1CodeRepositoryOwnerBuilder(item);
            if (index < 0 || index >= _visitables.get("owners").size()) { _visitables.get("owners").add(builder); } else { _visitables.get("owners").set(index, builder);}
            if (index < 0 || index >= owners.size()) { owners.add(builder); } else { owners.set(index, builder);}
             return (A)this;
    }

    public A addToOwners(V1alpha1CodeRepositoryOwner... items){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerBuilder>();}
            for (V1alpha1CodeRepositoryOwner item : items) {V1alpha1CodeRepositoryOwnerBuilder builder = new V1alpha1CodeRepositoryOwnerBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
    }

    public A addAllToOwners(Collection<V1alpha1CodeRepositoryOwner> items){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerBuilder>();}
            for (V1alpha1CodeRepositoryOwner item : items) {V1alpha1CodeRepositoryOwnerBuilder builder = new V1alpha1CodeRepositoryOwnerBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
    }

    public A removeFromOwners(V1alpha1CodeRepositoryOwner... items){
            for (V1alpha1CodeRepositoryOwner item : items) {V1alpha1CodeRepositoryOwnerBuilder builder = new V1alpha1CodeRepositoryOwnerBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
    }

    public A removeAllFromOwners(Collection<V1alpha1CodeRepositoryOwner> items){
            for (V1alpha1CodeRepositoryOwner item : items) {V1alpha1CodeRepositoryOwnerBuilder builder = new V1alpha1CodeRepositoryOwnerBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOwners instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1CodeRepositoryOwner> getOwners(){
            return build(owners);
    }

    public List<V1alpha1CodeRepositoryOwner> buildOwners(){
            return build(owners);
    }

    public V1alpha1CodeRepositoryOwner buildOwner(int index){
            return this.owners.get(index).build();
    }

    public V1alpha1CodeRepositoryOwner buildFirstOwner(){
            return this.owners.get(0).build();
    }

    public V1alpha1CodeRepositoryOwner buildLastOwner(){
            return this.owners.get(owners.size() - 1).build();
    }

    public V1alpha1CodeRepositoryOwner buildMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepositoryOwnerBuilder> predicate){
            for (V1alpha1CodeRepositoryOwnerBuilder item: owners) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepositoryOwnerBuilder> predicate){
            for (V1alpha1CodeRepositoryOwnerBuilder item: owners) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withOwners(List<V1alpha1CodeRepositoryOwner> owners){
            if (this.owners != null) { _visitables.get("owners").removeAll(this.owners);}
            if (owners != null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerBuilder>(); for (V1alpha1CodeRepositoryOwner item : owners){this.addToOwners(item);}} else { this.owners = null;} return (A) this;
    }

    public A withOwners(V1alpha1CodeRepositoryOwner... owners){
            if (this.owners != null) {this.owners.clear();}
            if (owners != null) {for (V1alpha1CodeRepositoryOwner item :owners){ this.addToOwners(item);}} return (A) this;
    }

    public Boolean hasOwners(){
            return owners != null && !owners.isEmpty();
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> addNewOwner(){
            return new OwnersNestedImpl();
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> addNewOwnerLike(V1alpha1CodeRepositoryOwner item){
            return new OwnersNestedImpl(-1, item);
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> setNewOwnerLike(int index,V1alpha1CodeRepositoryOwner item){
            return new OwnersNestedImpl(index, item);
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> editOwner(int index){
            if (owners.size() <= index) throw new RuntimeException("Can't edit owners. Index exceeds size.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> editFirstOwner(){
            if (owners.size() == 0) throw new RuntimeException("Can't edit first owners. The list is empty.");
            return setNewOwnerLike(0, buildOwner(0));
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> editLastOwner(){
            int index = owners.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last owners. The list is empty.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<A> editMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepositoryOwnerBuilder> predicate){
            int index = -1;
            for (int i=0;i<owners.size();i++) { 
            if (predicate.apply(owners.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching owners. No match found.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingRepositoriesFluentImpl that = (V1alpha1CodeRepoBindingRepositoriesFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (owners != null ? !owners.equals(that.owners) :that.owners != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class OwnersNestedImpl<N> extends V1alpha1CodeRepositoryOwnerFluentImpl<V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<N>> implements V1alpha1CodeRepoBindingRepositoriesFluent.OwnersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1CodeRepositoryOwnerBuilder builder;
        private final int index;
    
            OwnersNestedImpl(int index,V1alpha1CodeRepositoryOwner item){
                    this.index = index;
                    this.builder = new V1alpha1CodeRepositoryOwnerBuilder(this, item);
            }
            OwnersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1CodeRepositoryOwnerBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepoBindingRepositoriesFluentImpl.this.setToOwners(index, builder.build());
    }
    public N endOwner(){
            return and();
    }

}


}
