package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryOwnerSyncBuilder extends V1alpha1CodeRepositoryOwnerSyncFluentImpl<V1alpha1CodeRepositoryOwnerSyncBuilder> implements VisitableBuilder<V1alpha1CodeRepositoryOwnerSync,V1alpha1CodeRepositoryOwnerSyncBuilder>{

    V1alpha1CodeRepositoryOwnerSyncFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryOwnerSyncBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositoryOwnerSync(), validationEnabled);
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(V1alpha1CodeRepositoryOwnerSyncFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(V1alpha1CodeRepositoryOwnerSyncFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositoryOwnerSync(), validationEnabled);
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(V1alpha1CodeRepositoryOwnerSyncFluent<?> fluent,V1alpha1CodeRepositoryOwnerSync instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(V1alpha1CodeRepositoryOwnerSyncFluent<?> fluent,V1alpha1CodeRepositoryOwnerSync instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAll(instance.isAll());

            fluent.withName(instance.getName());

            fluent.withRepositories(instance.getRepositories());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(V1alpha1CodeRepositoryOwnerSync instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryOwnerSyncBuilder(V1alpha1CodeRepositoryOwnerSync instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAll(instance.isAll());

            this.withName(instance.getName());

            this.withRepositories(instance.getRepositories());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositoryOwnerSync build(){
            V1alpha1CodeRepositoryOwnerSync buildable = new V1alpha1CodeRepositoryOwnerSync();
            buildable.setAll(fluent.isAll());
            buildable.setName(fluent.getName());
            buildable.setRepositories(fluent.getRepositories());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryOwnerSyncBuilder that = (V1alpha1CodeRepositoryOwnerSyncBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
