package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryStatusRepositoryBuilder extends V1alpha1CodeRepositoryStatusRepositoryFluentImpl<V1alpha1CodeRepositoryStatusRepositoryBuilder> implements VisitableBuilder<V1alpha1CodeRepositoryStatusRepository,V1alpha1CodeRepositoryStatusRepositoryBuilder>{

    V1alpha1CodeRepositoryStatusRepositoryFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryStatusRepositoryBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositoryStatusRepository(), validationEnabled);
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(V1alpha1CodeRepositoryStatusRepositoryFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(V1alpha1CodeRepositoryStatusRepositoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositoryStatusRepository(), validationEnabled);
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(V1alpha1CodeRepositoryStatusRepositoryFluent<?> fluent,V1alpha1CodeRepositoryStatusRepository instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(V1alpha1CodeRepositoryStatusRepositoryFluent<?> fluent,V1alpha1CodeRepositoryStatusRepository instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLatestCommit(instance.getLatestCommit());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(V1alpha1CodeRepositoryStatusRepository instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryStatusRepositoryBuilder(V1alpha1CodeRepositoryStatusRepository instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLatestCommit(instance.getLatestCommit());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositoryStatusRepository build(){
            V1alpha1CodeRepositoryStatusRepository buildable = new V1alpha1CodeRepositoryStatusRepository();
            buildable.setLatestCommit(fluent.getLatestCommit());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryStatusRepositoryBuilder that = (V1alpha1CodeRepositoryStatusRepositoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
