package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1GlobalParameterBuilder extends V1alpha1GlobalParameterFluentImpl<V1alpha1GlobalParameterBuilder> implements VisitableBuilder<V1alpha1GlobalParameter,V1alpha1GlobalParameterBuilder>{

    V1alpha1GlobalParameterFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1GlobalParameterBuilder(){
            this(true);
    }
    public V1alpha1GlobalParameterBuilder(Boolean validationEnabled){
            this(new V1alpha1GlobalParameter(), validationEnabled);
    }
    public V1alpha1GlobalParameterBuilder(V1alpha1GlobalParameterFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1GlobalParameterBuilder(V1alpha1GlobalParameterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1GlobalParameter(), validationEnabled);
    }
    public V1alpha1GlobalParameterBuilder(V1alpha1GlobalParameterFluent<?> fluent,V1alpha1GlobalParameter instance){
            this(fluent, instance, true);
    }
    public V1alpha1GlobalParameterBuilder(V1alpha1GlobalParameterFluent<?> fluent,V1alpha1GlobalParameter instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDescription(instance.getDescription());

            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1GlobalParameterBuilder(V1alpha1GlobalParameter instance){
            this(instance,true);
    }
    public V1alpha1GlobalParameterBuilder(V1alpha1GlobalParameter instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDescription(instance.getDescription());

            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1GlobalParameter build(){
            V1alpha1GlobalParameter buildable = new V1alpha1GlobalParameter();
            buildable.setDescription(fluent.getDescription());
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1GlobalParameterBuilder that = (V1alpha1GlobalParameterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
