package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1ImageTagFluentImpl<A extends V1alpha1ImageTagFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ImageTagFluent<A>{

    private String author;
    private DateTime createdAt;
    private String digest;
    private Integer level;
    private String message;
    private String name;
    private String scanStatus;
    private String size;
    private List<V1alpha1SummaryBuilder> summary;
    private DateTime updatedAt;

    public V1alpha1ImageTagFluentImpl(){
    }
    public V1alpha1ImageTagFluentImpl(V1alpha1ImageTag instance){
            this.withAuthor(instance.getAuthor());

            this.withCreatedAt(instance.getCreatedAt());

            this.withDigest(instance.getDigest());

            this.withLevel(instance.getLevel());

            this.withMessage(instance.getMessage());

            this.withName(instance.getName());

            this.withScanStatus(instance.getScanStatus());

            this.withSize(instance.getSize());

            this.withSummary(instance.getSummary());

            this.withUpdatedAt(instance.getUpdatedAt());

    }

    public String getAuthor(){
            return this.author;
    }

    public A withAuthor(String author){
            this.author=author; return (A) this;
    }

    public Boolean hasAuthor(){
            return this.author != null;
    }

    public A withNewAuthor(String arg1){
            return (A)withAuthor(new String(arg1));
    }

    public A withNewAuthor(StringBuilder arg1){
            return (A)withAuthor(new String(arg1));
    }

    public A withNewAuthor(StringBuffer arg1){
            return (A)withAuthor(new String(arg1));
    }

    public DateTime getCreatedAt(){
            return this.createdAt;
    }

    public A withCreatedAt(DateTime createdAt){
            this.createdAt=createdAt; return (A) this;
    }

    public Boolean hasCreatedAt(){
            return this.createdAt != null;
    }

    public A withNewCreatedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withCreatedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewCreatedAt(Object arg0){
            return (A)withCreatedAt(new DateTime(arg0));
    }

    public A withNewCreatedAt(long arg0){
            return (A)withCreatedAt(new DateTime(arg0));
    }

    public String getDigest(){
            return this.digest;
    }

    public A withDigest(String digest){
            this.digest=digest; return (A) this;
    }

    public Boolean hasDigest(){
            return this.digest != null;
    }

    public A withNewDigest(String arg1){
            return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(StringBuilder arg1){
            return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(StringBuffer arg1){
            return (A)withDigest(new String(arg1));
    }

    public Integer getLevel(){
            return this.level;
    }

    public A withLevel(Integer level){
            this.level=level; return (A) this;
    }

    public Boolean hasLevel(){
            return this.level != null;
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getScanStatus(){
            return this.scanStatus;
    }

    public A withScanStatus(String scanStatus){
            this.scanStatus=scanStatus; return (A) this;
    }

    public Boolean hasScanStatus(){
            return this.scanStatus != null;
    }

    public A withNewScanStatus(String arg1){
            return (A)withScanStatus(new String(arg1));
    }

    public A withNewScanStatus(StringBuilder arg1){
            return (A)withScanStatus(new String(arg1));
    }

    public A withNewScanStatus(StringBuffer arg1){
            return (A)withScanStatus(new String(arg1));
    }

    public String getSize(){
            return this.size;
    }

    public A withSize(String size){
            this.size=size; return (A) this;
    }

    public Boolean hasSize(){
            return this.size != null;
    }

    public A withNewSize(String arg1){
            return (A)withSize(new String(arg1));
    }

    public A withNewSize(StringBuilder arg1){
            return (A)withSize(new String(arg1));
    }

    public A withNewSize(StringBuffer arg1){
            return (A)withSize(new String(arg1));
    }

    public A addToSummary(int index,V1alpha1Summary item){
            if (this.summary == null) {this.summary = new ArrayList<V1alpha1SummaryBuilder>();}
            V1alpha1SummaryBuilder builder = new V1alpha1SummaryBuilder(item);_visitables.get("summary").add(index >= 0 ? index : _visitables.get("summary").size(), builder);this.summary.add(index >= 0 ? index : summary.size(), builder); return (A)this;
    }

    public A setToSummary(int index,V1alpha1Summary item){
            if (this.summary == null) {this.summary = new ArrayList<V1alpha1SummaryBuilder>();}
            V1alpha1SummaryBuilder builder = new V1alpha1SummaryBuilder(item);
            if (index < 0 || index >= _visitables.get("summary").size()) { _visitables.get("summary").add(builder); } else { _visitables.get("summary").set(index, builder);}
            if (index < 0 || index >= summary.size()) { summary.add(builder); } else { summary.set(index, builder);}
             return (A)this;
    }

    public A addToSummary(V1alpha1Summary... items){
            if (this.summary == null) {this.summary = new ArrayList<V1alpha1SummaryBuilder>();}
            for (V1alpha1Summary item : items) {V1alpha1SummaryBuilder builder = new V1alpha1SummaryBuilder(item);_visitables.get("summary").add(builder);this.summary.add(builder);} return (A)this;
    }

    public A addAllToSummary(Collection<V1alpha1Summary> items){
            if (this.summary == null) {this.summary = new ArrayList<V1alpha1SummaryBuilder>();}
            for (V1alpha1Summary item : items) {V1alpha1SummaryBuilder builder = new V1alpha1SummaryBuilder(item);_visitables.get("summary").add(builder);this.summary.add(builder);} return (A)this;
    }

    public A removeFromSummary(V1alpha1Summary... items){
            for (V1alpha1Summary item : items) {V1alpha1SummaryBuilder builder = new V1alpha1SummaryBuilder(item);_visitables.get("summary").remove(builder);if (this.summary != null) {this.summary.remove(builder);}} return (A)this;
    }

    public A removeAllFromSummary(Collection<V1alpha1Summary> items){
            for (V1alpha1Summary item : items) {V1alpha1SummaryBuilder builder = new V1alpha1SummaryBuilder(item);_visitables.get("summary").remove(builder);if (this.summary != null) {this.summary.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSummary instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Summary> getSummary(){
            return build(summary);
    }

    public List<V1alpha1Summary> buildSummary(){
            return build(summary);
    }

    public V1alpha1Summary buildSummary(int index){
            return this.summary.get(index).build();
    }

    public V1alpha1Summary buildFirstSummary(){
            return this.summary.get(0).build();
    }

    public V1alpha1Summary buildLastSummary(){
            return this.summary.get(summary.size() - 1).build();
    }

    public V1alpha1Summary buildMatchingSummary(io.alauda.devops.java.client.fluent.Predicate<V1alpha1SummaryBuilder> predicate){
            for (V1alpha1SummaryBuilder item: summary) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSummary(io.alauda.devops.java.client.fluent.Predicate<V1alpha1SummaryBuilder> predicate){
            for (V1alpha1SummaryBuilder item: summary) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSummary(List<V1alpha1Summary> summary){
            if (this.summary != null) { _visitables.get("summary").removeAll(this.summary);}
            if (summary != null) {this.summary = new ArrayList<V1alpha1SummaryBuilder>(); for (V1alpha1Summary item : summary){this.addToSummary(item);}} else { this.summary = null;} return (A) this;
    }

    public A withSummary(V1alpha1Summary... summary){
            if (this.summary != null) {this.summary.clear();}
            if (summary != null) {for (V1alpha1Summary item :summary){ this.addToSummary(item);}} return (A) this;
    }

    public Boolean hasSummary(){
            return summary != null && !summary.isEmpty();
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> addNewSummary(){
            return new SummaryNestedImpl();
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> addNewSummaryLike(V1alpha1Summary item){
            return new SummaryNestedImpl(-1, item);
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> setNewSummaryLike(int index,V1alpha1Summary item){
            return new SummaryNestedImpl(index, item);
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> editSummary(int index){
            if (summary.size() <= index) throw new RuntimeException("Can't edit summary. Index exceeds size.");
            return setNewSummaryLike(index, buildSummary(index));
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> editFirstSummary(){
            if (summary.size() == 0) throw new RuntimeException("Can't edit first summary. The list is empty.");
            return setNewSummaryLike(0, buildSummary(0));
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> editLastSummary(){
            int index = summary.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last summary. The list is empty.");
            return setNewSummaryLike(index, buildSummary(index));
    }

    public V1alpha1ImageTagFluent.SummaryNested<A> editMatchingSummary(io.alauda.devops.java.client.fluent.Predicate<V1alpha1SummaryBuilder> predicate){
            int index = -1;
            for (int i=0;i<summary.size();i++) { 
            if (predicate.apply(summary.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching summary. No match found.");
            return setNewSummaryLike(index, buildSummary(index));
    }

    public DateTime getUpdatedAt(){
            return this.updatedAt;
    }

    public A withUpdatedAt(DateTime updatedAt){
            this.updatedAt=updatedAt; return (A) this;
    }

    public Boolean hasUpdatedAt(){
            return this.updatedAt != null;
    }

    public A withNewUpdatedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withUpdatedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewUpdatedAt(Object arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public A withNewUpdatedAt(long arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageTagFluentImpl that = (V1alpha1ImageTagFluentImpl) o;
            if (author != null ? !author.equals(that.author) :that.author != null) return false;
            if (createdAt != null ? !createdAt.equals(that.createdAt) :that.createdAt != null) return false;
            if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
            if (level != null ? !level.equals(that.level) :that.level != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (scanStatus != null ? !scanStatus.equals(that.scanStatus) :that.scanStatus != null) return false;
            if (size != null ? !size.equals(that.size) :that.size != null) return false;
            if (summary != null ? !summary.equals(that.summary) :that.summary != null) return false;
            if (updatedAt != null ? !updatedAt.equals(that.updatedAt) :that.updatedAt != null) return false;
            return true;
    }


    public class SummaryNestedImpl<N> extends V1alpha1SummaryFluentImpl<V1alpha1ImageTagFluent.SummaryNested<N>> implements V1alpha1ImageTagFluent.SummaryNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1SummaryBuilder builder;
        private final int index;
    
            SummaryNestedImpl(int index,V1alpha1Summary item){
                    this.index = index;
                    this.builder = new V1alpha1SummaryBuilder(this, item);
            }
            SummaryNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1SummaryBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ImageTagFluentImpl.this.setToSummary(index, builder.build());
    }
    public N endSummary(){
            return and();
    }

}


}
