package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1IssueSearchOptionsBuilder extends V1alpha1IssueSearchOptionsFluentImpl<V1alpha1IssueSearchOptionsBuilder> implements VisitableBuilder<V1alpha1IssueSearchOptions,V1alpha1IssueSearchOptionsBuilder>{

    V1alpha1IssueSearchOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1IssueSearchOptionsBuilder(){
            this(true);
    }
    public V1alpha1IssueSearchOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1IssueSearchOptions(), validationEnabled);
    }
    public V1alpha1IssueSearchOptionsBuilder(V1alpha1IssueSearchOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1IssueSearchOptionsBuilder(V1alpha1IssueSearchOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1IssueSearchOptions(), validationEnabled);
    }
    public V1alpha1IssueSearchOptionsBuilder(V1alpha1IssueSearchOptionsFluent<?> fluent,V1alpha1IssueSearchOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1IssueSearchOptionsBuilder(V1alpha1IssueSearchOptionsFluent<?> fluent,V1alpha1IssueSearchOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1IssueSearchOptionsBuilder(V1alpha1IssueSearchOptions instance){
            this(instance,true);
    }
    public V1alpha1IssueSearchOptionsBuilder(V1alpha1IssueSearchOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1IssueSearchOptions build(){
            V1alpha1IssueSearchOptions buildable = new V1alpha1IssueSearchOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1IssueSearchOptionsBuilder that = (V1alpha1IssueSearchOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
