package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsBindingInfoOptionsBuilder extends V1alpha1JenkinsBindingInfoOptionsFluentImpl<V1alpha1JenkinsBindingInfoOptionsBuilder> implements VisitableBuilder<V1alpha1JenkinsBindingInfoOptions,V1alpha1JenkinsBindingInfoOptionsBuilder>{

    V1alpha1JenkinsBindingInfoOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsBindingInfoOptionsBuilder(){
            this(true);
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsBindingInfoOptions(), validationEnabled);
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(V1alpha1JenkinsBindingInfoOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(V1alpha1JenkinsBindingInfoOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsBindingInfoOptions(), validationEnabled);
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(V1alpha1JenkinsBindingInfoOptionsFluent<?> fluent,V1alpha1JenkinsBindingInfoOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(V1alpha1JenkinsBindingInfoOptionsFluent<?> fluent,V1alpha1JenkinsBindingInfoOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withTarget(instance.getTarget());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(V1alpha1JenkinsBindingInfoOptions instance){
            this(instance,true);
    }
    public V1alpha1JenkinsBindingInfoOptionsBuilder(V1alpha1JenkinsBindingInfoOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withTarget(instance.getTarget());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsBindingInfoOptions build(){
            V1alpha1JenkinsBindingInfoOptions buildable = new V1alpha1JenkinsBindingInfoOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setTarget(fluent.getTarget());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsBindingInfoOptionsBuilder that = (V1alpha1JenkinsBindingInfoOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
