package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsInstanceBuilder extends V1alpha1JenkinsInstanceFluentImpl<V1alpha1JenkinsInstanceBuilder> implements VisitableBuilder<V1alpha1JenkinsInstance,V1alpha1JenkinsInstanceBuilder>{

    V1alpha1JenkinsInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsInstanceBuilder(){
            this(true);
    }
    public V1alpha1JenkinsInstanceBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsInstance(), validationEnabled);
    }
    public V1alpha1JenkinsInstanceBuilder(V1alpha1JenkinsInstanceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsInstanceBuilder(V1alpha1JenkinsInstanceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsInstance(), validationEnabled);
    }
    public V1alpha1JenkinsInstanceBuilder(V1alpha1JenkinsInstanceFluent<?> fluent,V1alpha1JenkinsInstance instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsInstanceBuilder(V1alpha1JenkinsInstanceFluent<?> fluent,V1alpha1JenkinsInstance instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsInstanceBuilder(V1alpha1JenkinsInstance instance){
            this(instance,true);
    }
    public V1alpha1JenkinsInstanceBuilder(V1alpha1JenkinsInstance instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsInstance build(){
            V1alpha1JenkinsInstance buildable = new V1alpha1JenkinsInstance();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsInstanceBuilder that = (V1alpha1JenkinsInstanceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
