package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1KeyValueBuilder extends V1alpha1KeyValueFluentImpl<V1alpha1KeyValueBuilder> implements VisitableBuilder<V1alpha1KeyValue,V1alpha1KeyValueBuilder>{

    V1alpha1KeyValueFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1KeyValueBuilder(){
            this(true);
    }
    public V1alpha1KeyValueBuilder(Boolean validationEnabled){
            this(new V1alpha1KeyValue(), validationEnabled);
    }
    public V1alpha1KeyValueBuilder(V1alpha1KeyValueFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1KeyValueBuilder(V1alpha1KeyValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1KeyValue(), validationEnabled);
    }
    public V1alpha1KeyValueBuilder(V1alpha1KeyValueFluent<?> fluent,V1alpha1KeyValue instance){
            this(fluent, instance, true);
    }
    public V1alpha1KeyValueBuilder(V1alpha1KeyValueFluent<?> fluent,V1alpha1KeyValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1KeyValueBuilder(V1alpha1KeyValue instance){
            this(instance,true);
    }
    public V1alpha1KeyValueBuilder(V1alpha1KeyValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1KeyValue build(){
            V1alpha1KeyValue buildable = new V1alpha1KeyValue();
            buildable.setName(fluent.getName());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1KeyValueBuilder that = (V1alpha1KeyValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
