package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1LocalObjectReferenceBuilder extends V1alpha1LocalObjectReferenceFluentImpl<V1alpha1LocalObjectReferenceBuilder> implements VisitableBuilder<V1alpha1LocalObjectReference,V1alpha1LocalObjectReferenceBuilder>{

    V1alpha1LocalObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1LocalObjectReferenceBuilder(){
            this(true);
    }
    public V1alpha1LocalObjectReferenceBuilder(Boolean validationEnabled){
            this(new V1alpha1LocalObjectReference(), validationEnabled);
    }
    public V1alpha1LocalObjectReferenceBuilder(V1alpha1LocalObjectReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1LocalObjectReferenceBuilder(V1alpha1LocalObjectReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1LocalObjectReference(), validationEnabled);
    }
    public V1alpha1LocalObjectReferenceBuilder(V1alpha1LocalObjectReferenceFluent<?> fluent,V1alpha1LocalObjectReference instance){
            this(fluent, instance, true);
    }
    public V1alpha1LocalObjectReferenceBuilder(V1alpha1LocalObjectReferenceFluent<?> fluent,V1alpha1LocalObjectReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1LocalObjectReferenceBuilder(V1alpha1LocalObjectReference instance){
            this(instance,true);
    }
    public V1alpha1LocalObjectReferenceBuilder(V1alpha1LocalObjectReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1LocalObjectReference build(){
            V1alpha1LocalObjectReference buildable = new V1alpha1LocalObjectReference();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1LocalObjectReferenceBuilder that = (V1alpha1LocalObjectReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
