package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import org.joda.time.DateTime;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1OriginCodeRepositoryFluentImpl<A extends V1alpha1OriginCodeRepositoryFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1OriginCodeRepositoryFluent<A>{

    private String cloneURL;
    private String codeRepoServiceType;
    private DateTime createdAt;
    private Map<String,String> data;
    private String description;
    private String fullName;
    private String htmlURL;
    private String id;
    private String language;
    private String name;
    private V1alpha1OwnerInRepositoryBuilder owner;
    private Boolean _private;
    private DateTime pushedAt;
    private Long size;
    private String sizeHumanize;
    private String sshURL;
    private DateTime updatedAt;

    public V1alpha1OriginCodeRepositoryFluentImpl(){
    }
    public V1alpha1OriginCodeRepositoryFluentImpl(V1alpha1OriginCodeRepository instance){
            this.withCloneURL(instance.getCloneURL());

            this.withCodeRepoServiceType(instance.getCodeRepoServiceType());

            this.withCreatedAt(instance.getCreatedAt());

            this.withData(instance.getData());

            this.withDescription(instance.getDescription());

            this.withFullName(instance.getFullName());

            this.withHtmlURL(instance.getHtmlURL());

            this.withId(instance.getId());

            this.withLanguage(instance.getLanguage());

            this.withName(instance.getName());

            this.withOwner(instance.getOwner());

            this.withPrivate(instance.isPrivate());

            this.withPushedAt(instance.getPushedAt());

            this.withSize(instance.getSize());

            this.withSizeHumanize(instance.getSizeHumanize());

            this.withSshURL(instance.getSshURL());

            this.withUpdatedAt(instance.getUpdatedAt());

    }

    public String getCloneURL(){
            return this.cloneURL;
    }

    public A withCloneURL(String cloneURL){
            this.cloneURL=cloneURL; return (A) this;
    }

    public Boolean hasCloneURL(){
            return this.cloneURL != null;
    }

    public A withNewCloneURL(String arg1){
            return (A)withCloneURL(new String(arg1));
    }

    public A withNewCloneURL(StringBuilder arg1){
            return (A)withCloneURL(new String(arg1));
    }

    public A withNewCloneURL(StringBuffer arg1){
            return (A)withCloneURL(new String(arg1));
    }

    public String getCodeRepoServiceType(){
            return this.codeRepoServiceType;
    }

    public A withCodeRepoServiceType(String codeRepoServiceType){
            this.codeRepoServiceType=codeRepoServiceType; return (A) this;
    }

    public Boolean hasCodeRepoServiceType(){
            return this.codeRepoServiceType != null;
    }

    public A withNewCodeRepoServiceType(String arg1){
            return (A)withCodeRepoServiceType(new String(arg1));
    }

    public A withNewCodeRepoServiceType(StringBuilder arg1){
            return (A)withCodeRepoServiceType(new String(arg1));
    }

    public A withNewCodeRepoServiceType(StringBuffer arg1){
            return (A)withCodeRepoServiceType(new String(arg1));
    }

    public DateTime getCreatedAt(){
            return this.createdAt;
    }

    public A withCreatedAt(DateTime createdAt){
            this.createdAt=createdAt; return (A) this;
    }

    public Boolean hasCreatedAt(){
            return this.createdAt != null;
    }

    public A withNewCreatedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withCreatedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewCreatedAt(Object arg0){
            return (A)withCreatedAt(new DateTime(arg0));
    }

    public A withNewCreatedAt(long arg0){
            return (A)withCreatedAt(new DateTime(arg0));
    }

    public A addToData(String key,String value){
            if(this.data == null && key != null && value != null) { this.data = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.data.put(key, value);} return (A)this;
    }

    public A addToData(Map<String,String> map){
            if(this.data == null && map != null) { this.data = new LinkedHashMap<String,String>(); }
            if(map != null) { this.data.putAll(map);} return (A)this;
    }

    public A removeFromData(String key){
            if(this.data == null) { return (A) this; }
            if(key != null && this.data != null) {this.data.remove(key);} return (A)this;
    }

    public A removeFromData(Map<String,String> map){
            if(this.data == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.data != null){this.data.remove(key);}}} return (A)this;
    }

    public Map<String,String> getData(){
            return this.data;
    }

    public A withData(Map<String,String> data){
            if (data == null) { this.data =  null;} else {this.data = new LinkedHashMap<String,String>(data);} return (A) this;
    }

    public Boolean hasData(){
            return this.data != null;
    }

    public String getDescription(){
            return this.description;
    }

    public A withDescription(String description){
            this.description=description; return (A) this;
    }

    public Boolean hasDescription(){
            return this.description != null;
    }

    public A withNewDescription(String arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1){
            return (A)withDescription(new String(arg1));
    }

    public String getFullName(){
            return this.fullName;
    }

    public A withFullName(String fullName){
            this.fullName=fullName; return (A) this;
    }

    public Boolean hasFullName(){
            return this.fullName != null;
    }

    public A withNewFullName(String arg1){
            return (A)withFullName(new String(arg1));
    }

    public A withNewFullName(StringBuilder arg1){
            return (A)withFullName(new String(arg1));
    }

    public A withNewFullName(StringBuffer arg1){
            return (A)withFullName(new String(arg1));
    }

    public String getHtmlURL(){
            return this.htmlURL;
    }

    public A withHtmlURL(String htmlURL){
            this.htmlURL=htmlURL; return (A) this;
    }

    public Boolean hasHtmlURL(){
            return this.htmlURL != null;
    }

    public A withNewHtmlURL(String arg1){
            return (A)withHtmlURL(new String(arg1));
    }

    public A withNewHtmlURL(StringBuilder arg1){
            return (A)withHtmlURL(new String(arg1));
    }

    public A withNewHtmlURL(StringBuffer arg1){
            return (A)withHtmlURL(new String(arg1));
    }

    public String getId(){
            return this.id;
    }

    public A withId(String id){
            this.id=id; return (A) this;
    }

    public Boolean hasId(){
            return this.id != null;
    }

    public A withNewId(String arg1){
            return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuilder arg1){
            return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuffer arg1){
            return (A)withId(new String(arg1));
    }

    public String getLanguage(){
            return this.language;
    }

    public A withLanguage(String language){
            this.language=language; return (A) this;
    }

    public Boolean hasLanguage(){
            return this.language != null;
    }

    public A withNewLanguage(String arg1){
            return (A)withLanguage(new String(arg1));
    }

    public A withNewLanguage(StringBuilder arg1){
            return (A)withLanguage(new String(arg1));
    }

    public A withNewLanguage(StringBuffer arg1){
            return (A)withLanguage(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOwner instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1OwnerInRepository getOwner(){
            return this.owner!=null?this.owner.build():null;
    }

    public V1alpha1OwnerInRepository buildOwner(){
            return this.owner!=null?this.owner.build():null;
    }

    public A withOwner(V1alpha1OwnerInRepository owner){
            _visitables.get("owner").remove(this.owner);
            if (owner!=null){ this.owner= new V1alpha1OwnerInRepositoryBuilder(owner); _visitables.get("owner").add(this.owner);} return (A) this;
    }

    public Boolean hasOwner(){
            return this.owner != null;
    }

    public V1alpha1OriginCodeRepositoryFluent.OwnerNested<A> withNewOwner(){
            return new OwnerNestedImpl();
    }

    public V1alpha1OriginCodeRepositoryFluent.OwnerNested<A> withNewOwnerLike(V1alpha1OwnerInRepository item){
            return new OwnerNestedImpl(item);
    }

    public V1alpha1OriginCodeRepositoryFluent.OwnerNested<A> editOwner(){
            return withNewOwnerLike(getOwner());
    }

    public V1alpha1OriginCodeRepositoryFluent.OwnerNested<A> editOrNewOwner(){
            return withNewOwnerLike(getOwner() != null ? getOwner(): new V1alpha1OwnerInRepositoryBuilder().build());
    }

    public V1alpha1OriginCodeRepositoryFluent.OwnerNested<A> editOrNewOwnerLike(V1alpha1OwnerInRepository item){
            return withNewOwnerLike(getOwner() != null ? getOwner(): item);
    }

    public Boolean isPrivate(){
            return this._private;
    }

    public A withPrivate(Boolean _private){
            this._private=_private; return (A) this;
    }

    public Boolean hasPrivate(){
            return this._private != null;
    }

    public A withNewPrivate(String arg1){
            return (A)withPrivate(new Boolean(arg1));
    }

    public A withNewPrivate(boolean arg1){
            return (A)withPrivate(new Boolean(arg1));
    }

    public DateTime getPushedAt(){
            return this.pushedAt;
    }

    public A withPushedAt(DateTime pushedAt){
            this.pushedAt=pushedAt; return (A) this;
    }

    public Boolean hasPushedAt(){
            return this.pushedAt != null;
    }

    public A withNewPushedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withPushedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewPushedAt(Object arg0){
            return (A)withPushedAt(new DateTime(arg0));
    }

    public A withNewPushedAt(long arg0){
            return (A)withPushedAt(new DateTime(arg0));
    }

    public Long getSize(){
            return this.size;
    }

    public A withSize(Long size){
            this.size=size; return (A) this;
    }

    public Boolean hasSize(){
            return this.size != null;
    }

    public String getSizeHumanize(){
            return this.sizeHumanize;
    }

    public A withSizeHumanize(String sizeHumanize){
            this.sizeHumanize=sizeHumanize; return (A) this;
    }

    public Boolean hasSizeHumanize(){
            return this.sizeHumanize != null;
    }

    public A withNewSizeHumanize(String arg1){
            return (A)withSizeHumanize(new String(arg1));
    }

    public A withNewSizeHumanize(StringBuilder arg1){
            return (A)withSizeHumanize(new String(arg1));
    }

    public A withNewSizeHumanize(StringBuffer arg1){
            return (A)withSizeHumanize(new String(arg1));
    }

    public String getSshURL(){
            return this.sshURL;
    }

    public A withSshURL(String sshURL){
            this.sshURL=sshURL; return (A) this;
    }

    public Boolean hasSshURL(){
            return this.sshURL != null;
    }

    public A withNewSshURL(String arg1){
            return (A)withSshURL(new String(arg1));
    }

    public A withNewSshURL(StringBuilder arg1){
            return (A)withSshURL(new String(arg1));
    }

    public A withNewSshURL(StringBuffer arg1){
            return (A)withSshURL(new String(arg1));
    }

    public DateTime getUpdatedAt(){
            return this.updatedAt;
    }

    public A withUpdatedAt(DateTime updatedAt){
            this.updatedAt=updatedAt; return (A) this;
    }

    public Boolean hasUpdatedAt(){
            return this.updatedAt != null;
    }

    public A withNewUpdatedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withUpdatedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewUpdatedAt(Object arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public A withNewUpdatedAt(long arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1OriginCodeRepositoryFluentImpl that = (V1alpha1OriginCodeRepositoryFluentImpl) o;
            if (cloneURL != null ? !cloneURL.equals(that.cloneURL) :that.cloneURL != null) return false;
            if (codeRepoServiceType != null ? !codeRepoServiceType.equals(that.codeRepoServiceType) :that.codeRepoServiceType != null) return false;
            if (createdAt != null ? !createdAt.equals(that.createdAt) :that.createdAt != null) return false;
            if (data != null ? !data.equals(that.data) :that.data != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (fullName != null ? !fullName.equals(that.fullName) :that.fullName != null) return false;
            if (htmlURL != null ? !htmlURL.equals(that.htmlURL) :that.htmlURL != null) return false;
            if (id != null ? !id.equals(that.id) :that.id != null) return false;
            if (language != null ? !language.equals(that.language) :that.language != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (owner != null ? !owner.equals(that.owner) :that.owner != null) return false;
            if (_private != null ? !_private.equals(that._private) :that._private != null) return false;
            if (pushedAt != null ? !pushedAt.equals(that.pushedAt) :that.pushedAt != null) return false;
            if (size != null ? !size.equals(that.size) :that.size != null) return false;
            if (sizeHumanize != null ? !sizeHumanize.equals(that.sizeHumanize) :that.sizeHumanize != null) return false;
            if (sshURL != null ? !sshURL.equals(that.sshURL) :that.sshURL != null) return false;
            if (updatedAt != null ? !updatedAt.equals(that.updatedAt) :that.updatedAt != null) return false;
            return true;
    }


    public class OwnerNestedImpl<N> extends V1alpha1OwnerInRepositoryFluentImpl<V1alpha1OriginCodeRepositoryFluent.OwnerNested<N>> implements V1alpha1OriginCodeRepositoryFluent.OwnerNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1OwnerInRepositoryBuilder builder;
    
            OwnerNestedImpl(V1alpha1OwnerInRepository item){
                    this.builder = new V1alpha1OwnerInRepositoryBuilder(this, item);
            }
            OwnerNestedImpl(){
                    this.builder = new V1alpha1OwnerInRepositoryBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1OriginCodeRepositoryFluentImpl.this.withOwner(builder.build());
    }
    public N endOwner(){
            return and();
    }

}


}
