package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineCauseBuilder extends V1alpha1PipelineCauseFluentImpl<V1alpha1PipelineCauseBuilder> implements VisitableBuilder<V1alpha1PipelineCause,V1alpha1PipelineCauseBuilder>{

    V1alpha1PipelineCauseFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineCauseBuilder(){
            this(true);
    }
    public V1alpha1PipelineCauseBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineCause(), validationEnabled);
    }
    public V1alpha1PipelineCauseBuilder(V1alpha1PipelineCauseFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineCauseBuilder(V1alpha1PipelineCauseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineCause(), validationEnabled);
    }
    public V1alpha1PipelineCauseBuilder(V1alpha1PipelineCauseFluent<?> fluent,V1alpha1PipelineCause instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineCauseBuilder(V1alpha1PipelineCauseFluent<?> fluent,V1alpha1PipelineCause instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineCauseBuilder(V1alpha1PipelineCause instance){
            this(instance,true);
    }
    public V1alpha1PipelineCauseBuilder(V1alpha1PipelineCause instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMessage(instance.getMessage());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineCause build(){
            V1alpha1PipelineCause buildable = new V1alpha1PipelineCause();
            buildable.setMessage(fluent.getMessage());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineCauseBuilder that = (V1alpha1PipelineCauseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
