package io.alauda.devops.java.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class V1alpha1PipelineHookHTTPRequestFluentImpl<A extends V1alpha1PipelineHookHTTPRequestFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineHookHTTPRequestFluent<A>{

    private Map<String,String> headers;
    private String method;
    private String uri;

    public V1alpha1PipelineHookHTTPRequestFluentImpl(){
    }
    public V1alpha1PipelineHookHTTPRequestFluentImpl(V1alpha1PipelineHookHTTPRequest instance){
            this.withHeaders(instance.getHeaders());

            this.withMethod(instance.getMethod());

            this.withUri(instance.getUri());

    }

    public A addToHeaders(String key,String value){
            if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
    }

    public A addToHeaders(Map<String,String> map){
            if(this.headers == null && map != null) { this.headers = new LinkedHashMap<String,String>(); }
            if(map != null) { this.headers.putAll(map);} return (A)this;
    }

    public A removeFromHeaders(String key){
            if(this.headers == null) { return (A) this; }
            if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
    }

    public A removeFromHeaders(Map<String,String> map){
            if(this.headers == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
    }

    public Map<String,String> getHeaders(){
            return this.headers;
    }

    public A withHeaders(Map<String,String> headers){
            if (headers == null) { this.headers =  null;} else {this.headers = new LinkedHashMap<String,String>(headers);} return (A) this;
    }

    public Boolean hasHeaders(){
            return this.headers != null;
    }

    public String getMethod(){
            return this.method;
    }

    public A withMethod(String method){
            this.method=method; return (A) this;
    }

    public Boolean hasMethod(){
            return this.method != null;
    }

    public A withNewMethod(String arg1){
            return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuilder arg1){
            return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuffer arg1){
            return (A)withMethod(new String(arg1));
    }

    public String getUri(){
            return this.uri;
    }

    public A withUri(String uri){
            this.uri=uri; return (A) this;
    }

    public Boolean hasUri(){
            return this.uri != null;
    }

    public A withNewUri(String arg1){
            return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuilder arg1){
            return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuffer arg1){
            return (A)withUri(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineHookHTTPRequestFluentImpl that = (V1alpha1PipelineHookHTTPRequestFluentImpl) o;
            if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
            if (method != null ? !method.equals(that.method) :that.method != null) return false;
            if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
            return true;
    }




}
