package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class V1alpha1PipelineSourceFluentImpl<A extends V1alpha1PipelineSourceFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineSourceFluent<A>{

    private V1alpha1CodeRepositoryRefBuilder codeRepository;
    private V1alpha1PipelineSourceDiskBuilder disk;
    private V1alpha1PipelineSourceGitBuilder git;
    private V1alpha1SecretKeySetRefBuilder secret;
    private String sourceType;
    private V1alpha1PipelineSourceSvnBuilder svn;

    public V1alpha1PipelineSourceFluentImpl(){
    }
    public V1alpha1PipelineSourceFluentImpl(V1alpha1PipelineSource instance){
            this.withCodeRepository(instance.getCodeRepository());

            this.withDisk(instance.getDisk());

            this.withGit(instance.getGit());

            this.withSecret(instance.getSecret());

            this.withSourceType(instance.getSourceType());

            this.withSvn(instance.getSvn());

    }

    
/**
 * This method has been deprecated, please use method buildCodeRepository instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1CodeRepositoryRef getCodeRepository(){
            return this.codeRepository!=null?this.codeRepository.build():null;
    }

    public V1alpha1CodeRepositoryRef buildCodeRepository(){
            return this.codeRepository!=null?this.codeRepository.build():null;
    }

    public A withCodeRepository(V1alpha1CodeRepositoryRef codeRepository){
            _visitables.get("codeRepository").remove(this.codeRepository);
            if (codeRepository!=null){ this.codeRepository= new V1alpha1CodeRepositoryRefBuilder(codeRepository); _visitables.get("codeRepository").add(this.codeRepository);} return (A) this;
    }

    public Boolean hasCodeRepository(){
            return this.codeRepository != null;
    }

    public V1alpha1PipelineSourceFluent.CodeRepositoryNested<A> withNewCodeRepository(){
            return new CodeRepositoryNestedImpl();
    }

    public V1alpha1PipelineSourceFluent.CodeRepositoryNested<A> withNewCodeRepositoryLike(V1alpha1CodeRepositoryRef item){
            return new CodeRepositoryNestedImpl(item);
    }

    public V1alpha1PipelineSourceFluent.CodeRepositoryNested<A> editCodeRepository(){
            return withNewCodeRepositoryLike(getCodeRepository());
    }

    public V1alpha1PipelineSourceFluent.CodeRepositoryNested<A> editOrNewCodeRepository(){
            return withNewCodeRepositoryLike(getCodeRepository() != null ? getCodeRepository(): new V1alpha1CodeRepositoryRefBuilder().build());
    }

    public V1alpha1PipelineSourceFluent.CodeRepositoryNested<A> editOrNewCodeRepositoryLike(V1alpha1CodeRepositoryRef item){
            return withNewCodeRepositoryLike(getCodeRepository() != null ? getCodeRepository(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDisk instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineSourceDisk getDisk(){
            return this.disk!=null?this.disk.build():null;
    }

    public V1alpha1PipelineSourceDisk buildDisk(){
            return this.disk!=null?this.disk.build():null;
    }

    public A withDisk(V1alpha1PipelineSourceDisk disk){
            _visitables.get("disk").remove(this.disk);
            if (disk!=null){ this.disk= new V1alpha1PipelineSourceDiskBuilder(disk); _visitables.get("disk").add(this.disk);} return (A) this;
    }

    public Boolean hasDisk(){
            return this.disk != null;
    }

    public V1alpha1PipelineSourceFluent.DiskNested<A> withNewDisk(){
            return new DiskNestedImpl();
    }

    public V1alpha1PipelineSourceFluent.DiskNested<A> withNewDiskLike(V1alpha1PipelineSourceDisk item){
            return new DiskNestedImpl(item);
    }

    public V1alpha1PipelineSourceFluent.DiskNested<A> editDisk(){
            return withNewDiskLike(getDisk());
    }

    public V1alpha1PipelineSourceFluent.DiskNested<A> editOrNewDisk(){
            return withNewDiskLike(getDisk() != null ? getDisk(): new V1alpha1PipelineSourceDiskBuilder().build());
    }

    public V1alpha1PipelineSourceFluent.DiskNested<A> editOrNewDiskLike(V1alpha1PipelineSourceDisk item){
            return withNewDiskLike(getDisk() != null ? getDisk(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGit instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineSourceGit getGit(){
            return this.git!=null?this.git.build():null;
    }

    public V1alpha1PipelineSourceGit buildGit(){
            return this.git!=null?this.git.build():null;
    }

    public A withGit(V1alpha1PipelineSourceGit git){
            _visitables.get("git").remove(this.git);
            if (git!=null){ this.git= new V1alpha1PipelineSourceGitBuilder(git); _visitables.get("git").add(this.git);} return (A) this;
    }

    public Boolean hasGit(){
            return this.git != null;
    }

    public V1alpha1PipelineSourceFluent.GitNested<A> withNewGit(){
            return new GitNestedImpl();
    }

    public V1alpha1PipelineSourceFluent.GitNested<A> withNewGitLike(V1alpha1PipelineSourceGit item){
            return new GitNestedImpl(item);
    }

    public V1alpha1PipelineSourceFluent.GitNested<A> editGit(){
            return withNewGitLike(getGit());
    }

    public V1alpha1PipelineSourceFluent.GitNested<A> editOrNewGit(){
            return withNewGitLike(getGit() != null ? getGit(): new V1alpha1PipelineSourceGitBuilder().build());
    }

    public V1alpha1PipelineSourceFluent.GitNested<A> editOrNewGitLike(V1alpha1PipelineSourceGit item){
            return withNewGitLike(getGit() != null ? getGit(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSecret instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1SecretKeySetRef getSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public V1alpha1SecretKeySetRef buildSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(V1alpha1SecretKeySetRef secret){
            _visitables.get("secret").remove(this.secret);
            if (secret!=null){ this.secret= new V1alpha1SecretKeySetRefBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
    }

    public Boolean hasSecret(){
            return this.secret != null;
    }

    public V1alpha1PipelineSourceFluent.SecretNested<A> withNewSecret(){
            return new SecretNestedImpl();
    }

    public V1alpha1PipelineSourceFluent.SecretNested<A> withNewSecretLike(V1alpha1SecretKeySetRef item){
            return new SecretNestedImpl(item);
    }

    public V1alpha1PipelineSourceFluent.SecretNested<A> editSecret(){
            return withNewSecretLike(getSecret());
    }

    public V1alpha1PipelineSourceFluent.SecretNested<A> editOrNewSecret(){
            return withNewSecretLike(getSecret() != null ? getSecret(): new V1alpha1SecretKeySetRefBuilder().build());
    }

    public V1alpha1PipelineSourceFluent.SecretNested<A> editOrNewSecretLike(V1alpha1SecretKeySetRef item){
            return withNewSecretLike(getSecret() != null ? getSecret(): item);
    }

    public String getSourceType(){
            return this.sourceType;
    }

    public A withSourceType(String sourceType){
            this.sourceType=sourceType; return (A) this;
    }

    public Boolean hasSourceType(){
            return this.sourceType != null;
    }

    public A withNewSourceType(String arg1){
            return (A)withSourceType(new String(arg1));
    }

    public A withNewSourceType(StringBuilder arg1){
            return (A)withSourceType(new String(arg1));
    }

    public A withNewSourceType(StringBuffer arg1){
            return (A)withSourceType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSvn instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineSourceSvn getSvn(){
            return this.svn!=null?this.svn.build():null;
    }

    public V1alpha1PipelineSourceSvn buildSvn(){
            return this.svn!=null?this.svn.build():null;
    }

    public A withSvn(V1alpha1PipelineSourceSvn svn){
            _visitables.get("svn").remove(this.svn);
            if (svn!=null){ this.svn= new V1alpha1PipelineSourceSvnBuilder(svn); _visitables.get("svn").add(this.svn);} return (A) this;
    }

    public Boolean hasSvn(){
            return this.svn != null;
    }

    public V1alpha1PipelineSourceFluent.SvnNested<A> withNewSvn(){
            return new SvnNestedImpl();
    }

    public V1alpha1PipelineSourceFluent.SvnNested<A> withNewSvnLike(V1alpha1PipelineSourceSvn item){
            return new SvnNestedImpl(item);
    }

    public V1alpha1PipelineSourceFluent.SvnNested<A> editSvn(){
            return withNewSvnLike(getSvn());
    }

    public V1alpha1PipelineSourceFluent.SvnNested<A> editOrNewSvn(){
            return withNewSvnLike(getSvn() != null ? getSvn(): new V1alpha1PipelineSourceSvnBuilder().build());
    }

    public V1alpha1PipelineSourceFluent.SvnNested<A> editOrNewSvnLike(V1alpha1PipelineSourceSvn item){
            return withNewSvnLike(getSvn() != null ? getSvn(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineSourceFluentImpl that = (V1alpha1PipelineSourceFluentImpl) o;
            if (codeRepository != null ? !codeRepository.equals(that.codeRepository) :that.codeRepository != null) return false;
            if (disk != null ? !disk.equals(that.disk) :that.disk != null) return false;
            if (git != null ? !git.equals(that.git) :that.git != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            if (sourceType != null ? !sourceType.equals(that.sourceType) :that.sourceType != null) return false;
            if (svn != null ? !svn.equals(that.svn) :that.svn != null) return false;
            return true;
    }


    public class CodeRepositoryNestedImpl<N> extends V1alpha1CodeRepositoryRefFluentImpl<V1alpha1PipelineSourceFluent.CodeRepositoryNested<N>> implements V1alpha1PipelineSourceFluent.CodeRepositoryNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1CodeRepositoryRefBuilder builder;
    
            CodeRepositoryNestedImpl(V1alpha1CodeRepositoryRef item){
                    this.builder = new V1alpha1CodeRepositoryRefBuilder(this, item);
            }
            CodeRepositoryNestedImpl(){
                    this.builder = new V1alpha1CodeRepositoryRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSourceFluentImpl.this.withCodeRepository(builder.build());
    }
    public N endCodeRepository(){
            return and();
    }

}
    public class DiskNestedImpl<N> extends V1alpha1PipelineSourceDiskFluentImpl<V1alpha1PipelineSourceFluent.DiskNested<N>> implements V1alpha1PipelineSourceFluent.DiskNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineSourceDiskBuilder builder;
    
            DiskNestedImpl(V1alpha1PipelineSourceDisk item){
                    this.builder = new V1alpha1PipelineSourceDiskBuilder(this, item);
            }
            DiskNestedImpl(){
                    this.builder = new V1alpha1PipelineSourceDiskBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSourceFluentImpl.this.withDisk(builder.build());
    }
    public N endDisk(){
            return and();
    }

}
    public class GitNestedImpl<N> extends V1alpha1PipelineSourceGitFluentImpl<V1alpha1PipelineSourceFluent.GitNested<N>> implements V1alpha1PipelineSourceFluent.GitNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineSourceGitBuilder builder;
    
            GitNestedImpl(V1alpha1PipelineSourceGit item){
                    this.builder = new V1alpha1PipelineSourceGitBuilder(this, item);
            }
            GitNestedImpl(){
                    this.builder = new V1alpha1PipelineSourceGitBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSourceFluentImpl.this.withGit(builder.build());
    }
    public N endGit(){
            return and();
    }

}
    public class SecretNestedImpl<N> extends V1alpha1SecretKeySetRefFluentImpl<V1alpha1PipelineSourceFluent.SecretNested<N>> implements V1alpha1PipelineSourceFluent.SecretNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1SecretKeySetRefBuilder builder;
    
            SecretNestedImpl(V1alpha1SecretKeySetRef item){
                    this.builder = new V1alpha1SecretKeySetRefBuilder(this, item);
            }
            SecretNestedImpl(){
                    this.builder = new V1alpha1SecretKeySetRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSourceFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret(){
            return and();
    }

}
    public class SvnNestedImpl<N> extends V1alpha1PipelineSourceSvnFluentImpl<V1alpha1PipelineSourceFluent.SvnNested<N>> implements V1alpha1PipelineSourceFluent.SvnNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineSourceSvnBuilder builder;
    
            SvnNestedImpl(V1alpha1PipelineSourceSvn item){
                    this.builder = new V1alpha1PipelineSourceSvnBuilder(this, item);
            }
            SvnNestedImpl(){
                    this.builder = new V1alpha1PipelineSourceSvnBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineSourceFluentImpl.this.withSvn(builder.build());
    }
    public N endSvn(){
            return and();
    }

}


}
