package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStatusBuilder extends V1alpha1PipelineStatusFluentImpl<V1alpha1PipelineStatusBuilder> implements VisitableBuilder<V1alpha1PipelineStatus,V1alpha1PipelineStatusBuilder>{

    V1alpha1PipelineStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStatusBuilder(){
            this(true);
    }
    public V1alpha1PipelineStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStatus(), validationEnabled);
    }
    public V1alpha1PipelineStatusBuilder(V1alpha1PipelineStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStatusBuilder(V1alpha1PipelineStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStatus(), validationEnabled);
    }
    public V1alpha1PipelineStatusBuilder(V1alpha1PipelineStatusFluent<?> fluent,V1alpha1PipelineStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStatusBuilder(V1alpha1PipelineStatusFluent<?> fluent,V1alpha1PipelineStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAborted(instance.isAborted());

            fluent.withFinishedAt(instance.getFinishedAt());

            fluent.withInformation(instance.getInformation());

            fluent.withJenkins(instance.getJenkins());

            fluent.withPhase(instance.getPhase());

            fluent.withStartedAt(instance.getStartedAt());

            fluent.withUpdatedAt(instance.getUpdatedAt());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStatusBuilder(V1alpha1PipelineStatus instance){
            this(instance,true);
    }
    public V1alpha1PipelineStatusBuilder(V1alpha1PipelineStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAborted(instance.isAborted());

            this.withFinishedAt(instance.getFinishedAt());

            this.withInformation(instance.getInformation());

            this.withJenkins(instance.getJenkins());

            this.withPhase(instance.getPhase());

            this.withStartedAt(instance.getStartedAt());

            this.withUpdatedAt(instance.getUpdatedAt());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStatus build(){
            V1alpha1PipelineStatus buildable = new V1alpha1PipelineStatus();
            buildable.setAborted(fluent.isAborted());
            buildable.setFinishedAt(fluent.getFinishedAt());
            buildable.setInformation(fluent.getInformation());
            buildable.setJenkins(fluent.getJenkins());
            buildable.setPhase(fluent.getPhase());
            buildable.setStartedAt(fluent.getStartedAt());
            buildable.setUpdatedAt(fluent.getUpdatedAt());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStatusBuilder that = (V1alpha1PipelineStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
