package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStatusInfoBuilder extends V1alpha1PipelineStatusInfoFluentImpl<V1alpha1PipelineStatusInfoBuilder> implements VisitableBuilder<V1alpha1PipelineStatusInfo,V1alpha1PipelineStatusInfoBuilder>{

    V1alpha1PipelineStatusInfoFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStatusInfoBuilder(){
            this(true);
    }
    public V1alpha1PipelineStatusInfoBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStatusInfo(), validationEnabled);
    }
    public V1alpha1PipelineStatusInfoBuilder(V1alpha1PipelineStatusInfoFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStatusInfoBuilder(V1alpha1PipelineStatusInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStatusInfo(), validationEnabled);
    }
    public V1alpha1PipelineStatusInfoBuilder(V1alpha1PipelineStatusInfoFluent<?> fluent,V1alpha1PipelineStatusInfo instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStatusInfoBuilder(V1alpha1PipelineStatusInfoFluent<?> fluent,V1alpha1PipelineStatusInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withItems(instance.getItems());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStatusInfoBuilder(V1alpha1PipelineStatusInfo instance){
            this(instance,true);
    }
    public V1alpha1PipelineStatusInfoBuilder(V1alpha1PipelineStatusInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withItems(instance.getItems());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStatusInfo build(){
            V1alpha1PipelineStatusInfo buildable = new V1alpha1PipelineStatusInfo();
            buildable.setItems(fluent.getItems());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStatusInfoBuilder that = (V1alpha1PipelineStatusInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
