package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStatusJenkinsBuilder extends V1alpha1PipelineStatusJenkinsFluentImpl<V1alpha1PipelineStatusJenkinsBuilder> implements VisitableBuilder<V1alpha1PipelineStatusJenkins,V1alpha1PipelineStatusJenkinsBuilder>{

    V1alpha1PipelineStatusJenkinsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStatusJenkinsBuilder(){
            this(true);
    }
    public V1alpha1PipelineStatusJenkinsBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStatusJenkins(), validationEnabled);
    }
    public V1alpha1PipelineStatusJenkinsBuilder(V1alpha1PipelineStatusJenkinsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStatusJenkinsBuilder(V1alpha1PipelineStatusJenkinsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStatusJenkins(), validationEnabled);
    }
    public V1alpha1PipelineStatusJenkinsBuilder(V1alpha1PipelineStatusJenkinsFluent<?> fluent,V1alpha1PipelineStatusJenkins instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStatusJenkinsBuilder(V1alpha1PipelineStatusJenkinsFluent<?> fluent,V1alpha1PipelineStatusJenkins instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBuild(instance.getBuild());

            fluent.withResult(instance.getResult());

            fluent.withStages(instance.getStages());

            fluent.withStartStageID(instance.getStartStageID());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStatusJenkinsBuilder(V1alpha1PipelineStatusJenkins instance){
            this(instance,true);
    }
    public V1alpha1PipelineStatusJenkinsBuilder(V1alpha1PipelineStatusJenkins instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBuild(instance.getBuild());

            this.withResult(instance.getResult());

            this.withStages(instance.getStages());

            this.withStartStageID(instance.getStartStageID());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStatusJenkins build(){
            V1alpha1PipelineStatusJenkins buildable = new V1alpha1PipelineStatusJenkins();
            buildable.setBuild(fluent.getBuild());
            buildable.setResult(fluent.getResult());
            buildable.setStages(fluent.getStages());
            buildable.setStartStageID(fluent.getStartStageID());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStatusJenkinsBuilder that = (V1alpha1PipelineStatusJenkinsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
