package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1PipelineTaskArgumentDisplayFluentImpl<A extends V1alpha1PipelineTaskArgumentDisplayFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTaskArgumentDisplayFluent<A>{

    private Boolean advanced;
    private Map<String,String> args;
    private V1alpha1I18nNameBuilder description;
    private V1alpha1I18nNameBuilder name;
    private String related;
    private String type;

    public V1alpha1PipelineTaskArgumentDisplayFluentImpl(){
    }
    public V1alpha1PipelineTaskArgumentDisplayFluentImpl(V1alpha1PipelineTaskArgumentDisplay instance){
            this.withAdvanced(instance.isAdvanced());

            this.withArgs(instance.getArgs());

            this.withDescription(instance.getDescription());

            this.withName(instance.getName());

            this.withRelated(instance.getRelated());

            this.withType(instance.getType());

    }

    public Boolean isAdvanced(){
            return this.advanced;
    }

    public A withAdvanced(Boolean advanced){
            this.advanced=advanced; return (A) this;
    }

    public Boolean hasAdvanced(){
            return this.advanced != null;
    }

    public A withNewAdvanced(String arg1){
            return (A)withAdvanced(new Boolean(arg1));
    }

    public A withNewAdvanced(boolean arg1){
            return (A)withAdvanced(new Boolean(arg1));
    }

    public A addToArgs(String key,String value){
            if(this.args == null && key != null && value != null) { this.args = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.args.put(key, value);} return (A)this;
    }

    public A addToArgs(Map<String,String> map){
            if(this.args == null && map != null) { this.args = new LinkedHashMap<String,String>(); }
            if(map != null) { this.args.putAll(map);} return (A)this;
    }

    public A removeFromArgs(String key){
            if(this.args == null) { return (A) this; }
            if(key != null && this.args != null) {this.args.remove(key);} return (A)this;
    }

    public A removeFromArgs(Map<String,String> map){
            if(this.args == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.args != null){this.args.remove(key);}}} return (A)this;
    }

    public Map<String,String> getArgs(){
            return this.args;
    }

    public A withArgs(Map<String,String> args){
            if (args == null) { this.args =  null;} else {this.args = new LinkedHashMap<String,String>(args);} return (A) this;
    }

    public Boolean hasArgs(){
            return this.args != null;
    }

    
/**
 * This method has been deprecated, please use method buildDescription instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1I18nName getDescription(){
            return this.description!=null?this.description.build():null;
    }

    public V1alpha1I18nName buildDescription(){
            return this.description!=null?this.description.build():null;
    }

    public A withDescription(V1alpha1I18nName description){
            _visitables.get("description").remove(this.description);
            if (description!=null){ this.description= new V1alpha1I18nNameBuilder(description); _visitables.get("description").add(this.description);} return (A) this;
    }

    public Boolean hasDescription(){
            return this.description != null;
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<A> withNewDescription(){
            return new DescriptionNestedImpl();
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<A> withNewDescriptionLike(V1alpha1I18nName item){
            return new DescriptionNestedImpl(item);
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<A> editDescription(){
            return withNewDescriptionLike(getDescription());
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<A> editOrNewDescription(){
            return withNewDescriptionLike(getDescription() != null ? getDescription(): new V1alpha1I18nNameBuilder().build());
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<A> editOrNewDescriptionLike(V1alpha1I18nName item){
            return withNewDescriptionLike(getDescription() != null ? getDescription(): item);
    }

    
/**
 * This method has been deprecated, please use method buildName instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1I18nName getName(){
            return this.name!=null?this.name.build():null;
    }

    public V1alpha1I18nName buildName(){
            return this.name!=null?this.name.build():null;
    }

    public A withName(V1alpha1I18nName name){
            _visitables.get("name").remove(this.name);
            if (name!=null){ this.name= new V1alpha1I18nNameBuilder(name); _visitables.get("name").add(this.name);} return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<A> withNewName(){
            return new NameNestedImpl();
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<A> withNewNameLike(V1alpha1I18nName item){
            return new NameNestedImpl(item);
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<A> editName(){
            return withNewNameLike(getName());
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<A> editOrNewName(){
            return withNewNameLike(getName() != null ? getName(): new V1alpha1I18nNameBuilder().build());
    }

    public V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<A> editOrNewNameLike(V1alpha1I18nName item){
            return withNewNameLike(getName() != null ? getName(): item);
    }

    public String getRelated(){
            return this.related;
    }

    public A withRelated(String related){
            this.related=related; return (A) this;
    }

    public Boolean hasRelated(){
            return this.related != null;
    }

    public A withNewRelated(String arg1){
            return (A)withRelated(new String(arg1));
    }

    public A withNewRelated(StringBuilder arg1){
            return (A)withRelated(new String(arg1));
    }

    public A withNewRelated(StringBuffer arg1){
            return (A)withRelated(new String(arg1));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskArgumentDisplayFluentImpl that = (V1alpha1PipelineTaskArgumentDisplayFluentImpl) o;
            if (advanced != null ? !advanced.equals(that.advanced) :that.advanced != null) return false;
            if (args != null ? !args.equals(that.args) :that.args != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (related != null ? !related.equals(that.related) :that.related != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class DescriptionNestedImpl<N> extends V1alpha1I18nNameFluentImpl<V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<N>> implements V1alpha1PipelineTaskArgumentDisplayFluent.DescriptionNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1I18nNameBuilder builder;
    
            DescriptionNestedImpl(V1alpha1I18nName item){
                    this.builder = new V1alpha1I18nNameBuilder(this, item);
            }
            DescriptionNestedImpl(){
                    this.builder = new V1alpha1I18nNameBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTaskArgumentDisplayFluentImpl.this.withDescription(builder.build());
    }
    public N endDescription(){
            return and();
    }

}
    public class NameNestedImpl<N> extends V1alpha1I18nNameFluentImpl<V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<N>> implements V1alpha1PipelineTaskArgumentDisplayFluent.NameNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1I18nNameBuilder builder;
    
            NameNestedImpl(V1alpha1I18nName item){
                    this.builder = new V1alpha1I18nNameBuilder(this, item);
            }
            NameNestedImpl(){
                    this.builder = new V1alpha1I18nNameBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTaskArgumentDisplayFluentImpl.this.withName(builder.build());
    }
    public N endName(){
            return and();
    }

}


}
