package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PipelineTaskFluentImpl<A extends V1alpha1PipelineTaskFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTaskFluent<A>{

    private String apiVersion;
    private String kind;
    private List<V1alpha1PipelineBlueOceanTaskBuilder> tasks;

    public V1alpha1PipelineTaskFluentImpl(){
    }
    public V1alpha1PipelineTaskFluentImpl(V1alpha1PipelineTask instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withTasks(instance.getTasks());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToTasks(int index,V1alpha1PipelineBlueOceanTask item){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineBlueOceanTaskBuilder>();}
            V1alpha1PipelineBlueOceanTaskBuilder builder = new V1alpha1PipelineBlueOceanTaskBuilder(item);_visitables.get("tasks").add(index >= 0 ? index : _visitables.get("tasks").size(), builder);this.tasks.add(index >= 0 ? index : tasks.size(), builder); return (A)this;
    }

    public A setToTasks(int index,V1alpha1PipelineBlueOceanTask item){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineBlueOceanTaskBuilder>();}
            V1alpha1PipelineBlueOceanTaskBuilder builder = new V1alpha1PipelineBlueOceanTaskBuilder(item);
            if (index < 0 || index >= _visitables.get("tasks").size()) { _visitables.get("tasks").add(builder); } else { _visitables.get("tasks").set(index, builder);}
            if (index < 0 || index >= tasks.size()) { tasks.add(builder); } else { tasks.set(index, builder);}
             return (A)this;
    }

    public A addToTasks(V1alpha1PipelineBlueOceanTask... items){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineBlueOceanTaskBuilder>();}
            for (V1alpha1PipelineBlueOceanTask item : items) {V1alpha1PipelineBlueOceanTaskBuilder builder = new V1alpha1PipelineBlueOceanTaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
    }

    public A addAllToTasks(Collection<V1alpha1PipelineBlueOceanTask> items){
            if (this.tasks == null) {this.tasks = new ArrayList<V1alpha1PipelineBlueOceanTaskBuilder>();}
            for (V1alpha1PipelineBlueOceanTask item : items) {V1alpha1PipelineBlueOceanTaskBuilder builder = new V1alpha1PipelineBlueOceanTaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
    }

    public A removeFromTasks(V1alpha1PipelineBlueOceanTask... items){
            for (V1alpha1PipelineBlueOceanTask item : items) {V1alpha1PipelineBlueOceanTaskBuilder builder = new V1alpha1PipelineBlueOceanTaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
    }

    public A removeAllFromTasks(Collection<V1alpha1PipelineBlueOceanTask> items){
            for (V1alpha1PipelineBlueOceanTask item : items) {V1alpha1PipelineBlueOceanTaskBuilder builder = new V1alpha1PipelineBlueOceanTaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTasks instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineBlueOceanTask> getTasks(){
            return build(tasks);
    }

    public List<V1alpha1PipelineBlueOceanTask> buildTasks(){
            return build(tasks);
    }

    public V1alpha1PipelineBlueOceanTask buildTask(int index){
            return this.tasks.get(index).build();
    }

    public V1alpha1PipelineBlueOceanTask buildFirstTask(){
            return this.tasks.get(0).build();
    }

    public V1alpha1PipelineBlueOceanTask buildLastTask(){
            return this.tasks.get(tasks.size() - 1).build();
    }

    public V1alpha1PipelineBlueOceanTask buildMatchingTask(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineBlueOceanTaskBuilder> predicate){
            for (V1alpha1PipelineBlueOceanTaskBuilder item: tasks) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTask(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineBlueOceanTaskBuilder> predicate){
            for (V1alpha1PipelineBlueOceanTaskBuilder item: tasks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTasks(List<V1alpha1PipelineBlueOceanTask> tasks){
            if (this.tasks != null) { _visitables.get("tasks").removeAll(this.tasks);}
            if (tasks != null) {this.tasks = new ArrayList<V1alpha1PipelineBlueOceanTaskBuilder>(); for (V1alpha1PipelineBlueOceanTask item : tasks){this.addToTasks(item);}} else { this.tasks = null;} return (A) this;
    }

    public A withTasks(V1alpha1PipelineBlueOceanTask... tasks){
            if (this.tasks != null) {this.tasks.clear();}
            if (tasks != null) {for (V1alpha1PipelineBlueOceanTask item :tasks){ this.addToTasks(item);}} return (A) this;
    }

    public Boolean hasTasks(){
            return tasks != null && !tasks.isEmpty();
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> addNewTask(){
            return new TasksNestedImpl();
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> addNewTaskLike(V1alpha1PipelineBlueOceanTask item){
            return new TasksNestedImpl(-1, item);
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> setNewTaskLike(int index,V1alpha1PipelineBlueOceanTask item){
            return new TasksNestedImpl(index, item);
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> editTask(int index){
            if (tasks.size() <= index) throw new RuntimeException("Can't edit tasks. Index exceeds size.");
            return setNewTaskLike(index, buildTask(index));
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> editFirstTask(){
            if (tasks.size() == 0) throw new RuntimeException("Can't edit first tasks. The list is empty.");
            return setNewTaskLike(0, buildTask(0));
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> editLastTask(){
            int index = tasks.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tasks. The list is empty.");
            return setNewTaskLike(index, buildTask(index));
    }

    public V1alpha1PipelineTaskFluent.TasksNested<A> editMatchingTask(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineBlueOceanTaskBuilder> predicate){
            int index = -1;
            for (int i=0;i<tasks.size();i++) { 
            if (predicate.apply(tasks.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tasks. No match found.");
            return setNewTaskLike(index, buildTask(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskFluentImpl that = (V1alpha1PipelineTaskFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (tasks != null ? !tasks.equals(that.tasks) :that.tasks != null) return false;
            return true;
    }


    public class TasksNestedImpl<N> extends V1alpha1PipelineBlueOceanTaskFluentImpl<V1alpha1PipelineTaskFluent.TasksNested<N>> implements V1alpha1PipelineTaskFluent.TasksNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineBlueOceanTaskBuilder builder;
        private final int index;
    
            TasksNestedImpl(int index,V1alpha1PipelineBlueOceanTask item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineBlueOceanTaskBuilder(this, item);
            }
            TasksNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineBlueOceanTaskBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTaskFluentImpl.this.setToTasks(index, builder.build());
    }
    public N endTask(){
            return and();
    }

}


}
