package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateMoldBuilder extends V1alpha1PipelineTemplateMoldFluentImpl<V1alpha1PipelineTemplateMoldBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateMold,V1alpha1PipelineTemplateMoldBuilder>{

    V1alpha1PipelineTemplateMoldFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateMoldBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateMoldBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateMold(), validationEnabled);
    }
    public V1alpha1PipelineTemplateMoldBuilder(V1alpha1PipelineTemplateMoldFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateMoldBuilder(V1alpha1PipelineTemplateMoldFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateMold(), validationEnabled);
    }
    public V1alpha1PipelineTemplateMoldBuilder(V1alpha1PipelineTemplateMoldFluent<?> fluent,V1alpha1PipelineTemplateMold instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateMoldBuilder(V1alpha1PipelineTemplateMoldFluent<?> fluent,V1alpha1PipelineTemplateMold instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateMoldBuilder(V1alpha1PipelineTemplateMold instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateMoldBuilder(V1alpha1PipelineTemplateMold instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateMold build(){
            V1alpha1PipelineTemplateMold buildable = new V1alpha1PipelineTemplateMold();
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateMoldBuilder that = (V1alpha1PipelineTemplateMoldBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
