package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateSyncSpecBuilder extends V1alpha1PipelineTemplateSyncSpecFluentImpl<V1alpha1PipelineTemplateSyncSpecBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateSyncSpec,V1alpha1PipelineTemplateSyncSpecBuilder>{

    V1alpha1PipelineTemplateSyncSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateSyncSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateSyncSpec(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(V1alpha1PipelineTemplateSyncSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(V1alpha1PipelineTemplateSyncSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateSyncSpec(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(V1alpha1PipelineTemplateSyncSpecFluent<?> fluent,V1alpha1PipelineTemplateSyncSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(V1alpha1PipelineTemplateSyncSpecFluent<?> fluent,V1alpha1PipelineTemplateSyncSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSource(instance.getSource());

            fluent.withStrategy(instance.getStrategy());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(V1alpha1PipelineTemplateSyncSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateSyncSpecBuilder(V1alpha1PipelineTemplateSyncSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSource(instance.getSource());

            this.withStrategy(instance.getStrategy());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateSyncSpec build(){
            V1alpha1PipelineTemplateSyncSpec buildable = new V1alpha1PipelineTemplateSyncSpec();
            buildable.setSource(fluent.getSource());
            buildable.setStrategy(fluent.getStrategy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSyncSpecBuilder that = (V1alpha1PipelineTemplateSyncSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
