package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateTaskInstanceSpecBuilder extends V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateTaskInstanceSpec,V1alpha1PipelineTemplateTaskInstanceSpecBuilder>{

    V1alpha1PipelineTemplateTaskInstanceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateTaskInstanceSpec(), validationEnabled);
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(V1alpha1PipelineTemplateTaskInstanceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(V1alpha1PipelineTemplateTaskInstanceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateTaskInstanceSpec(), validationEnabled);
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(V1alpha1PipelineTemplateTaskInstanceSpecFluent<?> fluent,V1alpha1PipelineTemplateTaskInstanceSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(V1alpha1PipelineTemplateTaskInstanceSpecFluent<?> fluent,V1alpha1PipelineTemplateTaskInstanceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAgent(instance.getAgent());

            fluent.withApprove(instance.getApprove());

            fluent.withArguments(instance.getArguments());

            fluent.withBody(instance.getBody());

            fluent.withEngine(instance.getEngine());

            fluent.withEnvironments(instance.getEnvironments());

            fluent.withExports(instance.getExports());

            fluent.withOptions(instance.getOptions());

            fluent.withRelation(instance.getRelation());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(V1alpha1PipelineTemplateTaskInstanceSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecBuilder(V1alpha1PipelineTemplateTaskInstanceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAgent(instance.getAgent());

            this.withApprove(instance.getApprove());

            this.withArguments(instance.getArguments());

            this.withBody(instance.getBody());

            this.withEngine(instance.getEngine());

            this.withEnvironments(instance.getEnvironments());

            this.withExports(instance.getExports());

            this.withOptions(instance.getOptions());

            this.withRelation(instance.getRelation());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateTaskInstanceSpec build(){
            V1alpha1PipelineTemplateTaskInstanceSpec buildable = new V1alpha1PipelineTemplateTaskInstanceSpec();
            buildable.setAgent(fluent.getAgent());
            buildable.setApprove(fluent.getApprove());
            buildable.setArguments(fluent.getArguments());
            buildable.setBody(fluent.getBody());
            buildable.setEngine(fluent.getEngine());
            buildable.setEnvironments(fluent.getEnvironments());
            buildable.setExports(fluent.getExports());
            buildable.setOptions(fluent.getOptions());
            buildable.setRelation(fluent.getRelation());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateTaskInstanceSpecBuilder that = (V1alpha1PipelineTemplateTaskInstanceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
