package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTestReportItemBuilder extends V1alpha1PipelineTestReportItemFluentImpl<V1alpha1PipelineTestReportItemBuilder> implements VisitableBuilder<V1alpha1PipelineTestReportItem,V1alpha1PipelineTestReportItemBuilder>{

    V1alpha1PipelineTestReportItemFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTestReportItemBuilder(){
            this(true);
    }
    public V1alpha1PipelineTestReportItemBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTestReportItem(), validationEnabled);
    }
    public V1alpha1PipelineTestReportItemBuilder(V1alpha1PipelineTestReportItemFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTestReportItemBuilder(V1alpha1PipelineTestReportItemFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTestReportItem(), validationEnabled);
    }
    public V1alpha1PipelineTestReportItemBuilder(V1alpha1PipelineTestReportItemFluent<?> fluent,V1alpha1PipelineTestReportItem instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTestReportItemBuilder(V1alpha1PipelineTestReportItemFluent<?> fluent,V1alpha1PipelineTestReportItem instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAge(instance.getAge());

            fluent.withDuration(instance.getDuration());

            fluent.withErrorDetails(instance.getErrorDetails());

            fluent.withErrorStackTrace(instance.getErrorStackTrace());

            fluent.withHasStdLog(instance.isHasStdLog());

            fluent.withId(instance.getId());

            fluent.withName(instance.getName());

            fluent.withState(instance.getState());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTestReportItemBuilder(V1alpha1PipelineTestReportItem instance){
            this(instance,true);
    }
    public V1alpha1PipelineTestReportItemBuilder(V1alpha1PipelineTestReportItem instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAge(instance.getAge());

            this.withDuration(instance.getDuration());

            this.withErrorDetails(instance.getErrorDetails());

            this.withErrorStackTrace(instance.getErrorStackTrace());

            this.withHasStdLog(instance.isHasStdLog());

            this.withId(instance.getId());

            this.withName(instance.getName());

            this.withState(instance.getState());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTestReportItem build(){
            V1alpha1PipelineTestReportItem buildable = new V1alpha1PipelineTestReportItem();
            buildable.setAge(fluent.getAge());
            buildable.setDuration(fluent.getDuration());
            buildable.setErrorDetails(fluent.getErrorDetails());
            buildable.setErrorStackTrace(fluent.getErrorStackTrace());
            buildable.setHasStdLog(fluent.isHasStdLog());
            buildable.setId(fluent.getId());
            buildable.setName(fluent.getName());
            buildable.setState(fluent.getState());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTestReportItemBuilder that = (V1alpha1PipelineTestReportItemBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
