package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTriggerCronBuilder extends V1alpha1PipelineTriggerCronFluentImpl<V1alpha1PipelineTriggerCronBuilder> implements VisitableBuilder<V1alpha1PipelineTriggerCron,V1alpha1PipelineTriggerCronBuilder>{

    V1alpha1PipelineTriggerCronFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTriggerCronBuilder(){
            this(true);
    }
    public V1alpha1PipelineTriggerCronBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTriggerCron(), validationEnabled);
    }
    public V1alpha1PipelineTriggerCronBuilder(V1alpha1PipelineTriggerCronFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTriggerCronBuilder(V1alpha1PipelineTriggerCronFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTriggerCron(), validationEnabled);
    }
    public V1alpha1PipelineTriggerCronBuilder(V1alpha1PipelineTriggerCronFluent<?> fluent,V1alpha1PipelineTriggerCron instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTriggerCronBuilder(V1alpha1PipelineTriggerCronFluent<?> fluent,V1alpha1PipelineTriggerCron instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEnabled(instance.isEnabled());

            fluent.withRule(instance.getRule());

            fluent.withSchedule(instance.getSchedule());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTriggerCronBuilder(V1alpha1PipelineTriggerCron instance){
            this(instance,true);
    }
    public V1alpha1PipelineTriggerCronBuilder(V1alpha1PipelineTriggerCron instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEnabled(instance.isEnabled());

            this.withRule(instance.getRule());

            this.withSchedule(instance.getSchedule());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTriggerCron build(){
            V1alpha1PipelineTriggerCron buildable = new V1alpha1PipelineTriggerCron();
            buildable.setEnabled(fluent.isEnabled());
            buildable.setRule(fluent.getRule());
            buildable.setSchedule(fluent.getSchedule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTriggerCronBuilder that = (V1alpha1PipelineTriggerCronBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
