package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ProjectDataBuilder extends V1alpha1ProjectDataFluentImpl<V1alpha1ProjectDataBuilder> implements VisitableBuilder<V1alpha1ProjectData,V1alpha1ProjectDataBuilder>{

    V1alpha1ProjectDataFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ProjectDataBuilder(){
            this(true);
    }
    public V1alpha1ProjectDataBuilder(Boolean validationEnabled){
            this(new V1alpha1ProjectData(), validationEnabled);
    }
    public V1alpha1ProjectDataBuilder(V1alpha1ProjectDataFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ProjectDataBuilder(V1alpha1ProjectDataFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ProjectData(), validationEnabled);
    }
    public V1alpha1ProjectDataBuilder(V1alpha1ProjectDataFluent<?> fluent,V1alpha1ProjectData instance){
            this(fluent, instance, true);
    }
    public V1alpha1ProjectDataBuilder(V1alpha1ProjectDataFluent<?> fluent,V1alpha1ProjectData instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withData(instance.getData());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ProjectDataBuilder(V1alpha1ProjectData instance){
            this(instance,true);
    }
    public V1alpha1ProjectDataBuilder(V1alpha1ProjectData instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ProjectData build(){
            V1alpha1ProjectData buildable = new V1alpha1ProjectData();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setData(fluent.getData());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectDataBuilder that = (V1alpha1ProjectDataBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
