package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1alpha1ProjectDataFluentImpl<A extends V1alpha1ProjectDataFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ProjectDataFluent<A>{

    private String apiVersion;
    private Map<String,String> data;
    private String kind;
    private V1ObjectMeta metadata;

    public V1alpha1ProjectDataFluentImpl(){
    }
    public V1alpha1ProjectDataFluentImpl(V1alpha1ProjectData instance){
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToData(String key,String value){
            if(this.data == null && key != null && value != null) { this.data = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.data.put(key, value);} return (A)this;
    }

    public A addToData(Map<String,String> map){
            if(this.data == null && map != null) { this.data = new LinkedHashMap<String,String>(); }
            if(map != null) { this.data.putAll(map);} return (A)this;
    }

    public A removeFromData(String key){
            if(this.data == null) { return (A) this; }
            if(key != null && this.data != null) {this.data.remove(key);} return (A)this;
    }

    public A removeFromData(Map<String,String> map){
            if(this.data == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.data != null){this.data.remove(key);}}} return (A)this;
    }

    public Map<String,String> getData(){
            return this.data;
    }

    public A withData(Map<String,String> data){
            if (data == null) { this.data =  null;} else {this.data = new LinkedHashMap<String,String>(data);} return (A) this;
    }

    public Boolean hasData(){
            return this.data != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectDataFluentImpl that = (V1alpha1ProjectDataFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (data != null ? !data.equals(that.data) :that.data != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }




}
