package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1TemplateStatusBuilder extends V1alpha1TemplateStatusFluentImpl<V1alpha1TemplateStatusBuilder> implements VisitableBuilder<V1alpha1TemplateStatus,V1alpha1TemplateStatusBuilder>{

    V1alpha1TemplateStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1TemplateStatusBuilder(){
            this(true);
    }
    public V1alpha1TemplateStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1TemplateStatus(), validationEnabled);
    }
    public V1alpha1TemplateStatusBuilder(V1alpha1TemplateStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1TemplateStatusBuilder(V1alpha1TemplateStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1TemplateStatus(), validationEnabled);
    }
    public V1alpha1TemplateStatusBuilder(V1alpha1TemplateStatusFluent<?> fluent,V1alpha1TemplateStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1TemplateStatusBuilder(V1alpha1TemplateStatusFluent<?> fluent,V1alpha1TemplateStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1TemplateStatusBuilder(V1alpha1TemplateStatus instance){
            this(instance,true);
    }
    public V1alpha1TemplateStatusBuilder(V1alpha1TemplateStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1TemplateStatus build(){
            V1alpha1TemplateStatus buildable = new V1alpha1TemplateStatus();
            buildable.setPhase(fluent.getPhase());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1TemplateStatusBuilder that = (V1alpha1TemplateStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
