package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolCategoryBuilder extends V1alpha1ToolCategoryFluentImpl<V1alpha1ToolCategoryBuilder> implements VisitableBuilder<V1alpha1ToolCategory,V1alpha1ToolCategoryBuilder>{

    V1alpha1ToolCategoryFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolCategoryBuilder(){
            this(true);
    }
    public V1alpha1ToolCategoryBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolCategory(), validationEnabled);
    }
    public V1alpha1ToolCategoryBuilder(V1alpha1ToolCategoryFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolCategoryBuilder(V1alpha1ToolCategoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolCategory(), validationEnabled);
    }
    public V1alpha1ToolCategoryBuilder(V1alpha1ToolCategoryFluent<?> fluent,V1alpha1ToolCategory instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolCategoryBuilder(V1alpha1ToolCategoryFluent<?> fluent,V1alpha1ToolCategory instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolCategoryBuilder(V1alpha1ToolCategory instance){
            this(instance,true);
    }
    public V1alpha1ToolCategoryBuilder(V1alpha1ToolCategory instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolCategory build(){
            V1alpha1ToolCategory buildable = new V1alpha1ToolCategory();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolCategoryBuilder that = (V1alpha1ToolCategoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
